@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin

import com.pulumi.azurenative.containerservice.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [TrustedAccessRoleBinding].
 */
@PulumiTagMarker
public class TrustedAccessRoleBindingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrustedAccessRoleBindingArgs = TrustedAccessRoleBindingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrustedAccessRoleBindingArgsBuilder.() -> Unit) {
        val builder = TrustedAccessRoleBindingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TrustedAccessRoleBinding {
        val builtJavaResource =
            com.pulumi.azurenative.containerservice.TrustedAccessRoleBinding(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TrustedAccessRoleBinding(builtJavaResource)
    }
}

/**
 * Defines binding between a resource and role
 * Azure REST API version: 2023-05-02-preview. Prior API version in Azure Native 1.x: 2022-04-02-preview.
 * Other available API versions: 2023-06-02-preview, 2023-07-02-preview, 2023-08-02-preview, 2023-09-01, 2023-09-02-preview, 2023-10-01, 2023-10-02-preview, 2023-11-01, 2023-11-02-preview, 2024-01-01, 2024-01-02-preview.
 * ## Example Usage
 * ### Create or update a trusted access role binding
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var trustedAccessRoleBinding = new AzureNative.ContainerService.TrustedAccessRoleBinding("trustedAccessRoleBinding", new()
 *     {
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         Roles = new[]
 *         {
 *             "Microsoft.MachineLearningServices/workspaces/reader",
 *             "Microsoft.MachineLearningServices/workspaces/writer",
 *         },
 *         SourceResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/b/providers/Microsoft.MachineLearningServices/workspaces/c",
 *         TrustedAccessRoleBindingName = "binding1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewTrustedAccessRoleBinding(ctx, "trustedAccessRoleBinding", &containerservice.TrustedAccessRoleBindingArgs{
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			Roles: pulumi.StringArray{
 * 				pulumi.String("Microsoft.MachineLearningServices/workspaces/reader"),
 * 				pulumi.String("Microsoft.MachineLearningServices/workspaces/writer"),
 * 			},
 * 			SourceResourceId:             pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/b/providers/Microsoft.MachineLearningServices/workspaces/c"),
 * 			TrustedAccessRoleBindingName: pulumi.String("binding1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.TrustedAccessRoleBinding;
 * import com.pulumi.azurenative.containerservice.TrustedAccessRoleBindingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var trustedAccessRoleBinding = new TrustedAccessRoleBinding("trustedAccessRoleBinding", TrustedAccessRoleBindingArgs.builder()
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .roles(
 *                 "Microsoft.MachineLearningServices/workspaces/reader",
 *                 "Microsoft.MachineLearningServices/workspaces/writer")
 *             .sourceResourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/b/providers/Microsoft.MachineLearningServices/workspaces/c")
 *             .trustedAccessRoleBindingName("binding1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerservice:TrustedAccessRoleBinding binding1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/trustedAccessRoleBindings/{trustedAccessRoleBindingName}
 * ```
 */
public class TrustedAccessRoleBinding internal constructor(
    override val javaResource: com.pulumi.azurenative.containerservice.TrustedAccessRoleBinding,
) : KotlinCustomResource(javaResource, TrustedAccessRoleBindingMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The current provisioning state of trusted access role binding.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * A list of roles to bind, each item is a resource type qualified role name. For example: 'Microsoft.MachineLearningServices/workspaces/reader'.
     */
    public val roles: Output<List<String>>
        get() = javaResource.roles().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The ARM resource ID of source resource that trusted access is configured for.
     */
    public val sourceResourceId: Output<String>
        get() = javaResource.sourceResourceId().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TrustedAccessRoleBindingMapper : ResourceMapper<TrustedAccessRoleBinding> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerservice.TrustedAccessRoleBinding::class == javaResource::class

    override fun map(javaResource: Resource): TrustedAccessRoleBinding =
        TrustedAccessRoleBinding(
            javaResource as
                com.pulumi.azurenative.containerservice.TrustedAccessRoleBinding,
        )
}

/**
 * @see [TrustedAccessRoleBinding].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TrustedAccessRoleBinding].
 */
public suspend fun trustedAccessRoleBinding(
    name: String,
    block: suspend TrustedAccessRoleBindingResourceBuilder.() -> Unit,
): TrustedAccessRoleBinding {
    val builder = TrustedAccessRoleBindingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TrustedAccessRoleBinding].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trustedAccessRoleBinding(name: String): TrustedAccessRoleBinding {
    val builder = TrustedAccessRoleBindingResourceBuilder()
    builder.name(name)
    return builder.build()
}
