@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin

import com.pulumi.azurenative.containerservice.UpdateRunArgs.builder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterUpdateArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterUpdateArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.UpdateRunStrategyArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.UpdateRunStrategyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A multi-stage process to perform update operations across members of a Fleet.
 * Azure REST API version: 2023-03-15-preview.
 * Other available API versions: 2023-06-15-preview, 2023-08-15-preview, 2023-10-15.
 * ## Example Usage
 * ### Create an UpdateRun.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var updateRun = new AzureNative.ContainerService.UpdateRun("updateRun", new()
 *     {
 *         FleetName = "fleet1",
 *         ManagedClusterUpdate = new AzureNative.ContainerService.Inputs.ManagedClusterUpdateArgs
 *         {
 *             Upgrade = new AzureNative.ContainerService.Inputs.ManagedClusterUpgradeSpecArgs
 *             {
 *                 KubernetesVersion = "1.26.1",
 *                 Type = "Full",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Strategy = new AzureNative.ContainerService.Inputs.UpdateRunStrategyArgs
 *         {
 *             Stages = new[]
 *             {
 *                 new AzureNative.ContainerService.Inputs.UpdateStageArgs
 *                 {
 *                     AfterStageWaitInSeconds = 3600,
 *                     Groups = new[]
 *                     {
 *                         new AzureNative.ContainerService.Inputs.UpdateGroupArgs
 *                         {
 *                             Name = "group-a",
 *                         },
 *                     },
 *                     Name = "stage1",
 *                 },
 *             },
 *         },
 *         UpdateRunName = "run1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewUpdateRun(ctx, "updateRun", &containerservice.UpdateRunArgs{
 * FleetName: pulumi.String("fleet1"),
 * ManagedClusterUpdate: containerservice.ManagedClusterUpdateResponse{
 * Upgrade: &containerservice.ManagedClusterUpgradeSpecArgs{
 * KubernetesVersion: pulumi.String("1.26.1"),
 * Type: pulumi.String("Full"),
 * },
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * Strategy: containerservice.UpdateRunStrategyResponse{
 * Stages: containerservice.UpdateStageArray{
 * interface{}{
 * AfterStageWaitInSeconds: pulumi.Int(3600),
 * Groups: containerservice.UpdateGroupArray{
 * &containerservice.UpdateGroupArgs{
 * Name: pulumi.String("group-a"),
 * },
 * },
 * Name: pulumi.String("stage1"),
 * },
 * },
 * },
 * UpdateRunName: pulumi.String("run1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.UpdateRun;
 * import com.pulumi.azurenative.containerservice.UpdateRunArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var updateRun = new UpdateRun("updateRun", UpdateRunArgs.builder()
 *             .fleetName("fleet1")
 *             .managedClusterUpdate(Map.of("upgrade", Map.ofEntries(
 *                 Map.entry("kubernetesVersion", "1.26.1"),
 *                 Map.entry("type", "Full")
 *             )))
 *             .resourceGroupName("rg1")
 *             .strategy(Map.of("stages", Map.ofEntries(
 *                 Map.entry("afterStageWaitInSeconds", 3600),
 *                 Map.entry("groups", Map.of("name", "group-a")),
 *                 Map.entry("name", "stage1")
 *             )))
 *             .updateRunName("run1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerservice:UpdateRun run1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/fleets/{fleetName}/updateRuns/{updateRunName}
 * ```
 * @property fleetName The name of the Fleet resource.
 * @property managedClusterUpdate The update to be applied to all clusters in the UpdateRun. The managedClusterUpdate can be modified until the run is started.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property strategy The strategy defines the order in which the clusters will be updated.
 * If not set, all members will be updated sequentially. The UpdateRun status will show a single UpdateStage and a single UpdateGroup targeting all members.
 * The strategy of the UpdateRun can be modified until the run is started.
 * @property updateRunName The name of the UpdateRun resource.
 */
public data class UpdateRunArgs(
    public val fleetName: Output<String>? = null,
    public val managedClusterUpdate: Output<ManagedClusterUpdateArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val strategy: Output<UpdateRunStrategyArgs>? = null,
    public val updateRunName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.UpdateRunArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.UpdateRunArgs =
        com.pulumi.azurenative.containerservice.UpdateRunArgs.builder()
            .fleetName(fleetName?.applyValue({ args0 -> args0 }))
            .managedClusterUpdate(
                managedClusterUpdate?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .strategy(strategy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .updateRunName(updateRunName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UpdateRunArgs].
 */
@PulumiTagMarker
public class UpdateRunArgsBuilder internal constructor() {
    private var fleetName: Output<String>? = null

    private var managedClusterUpdate: Output<ManagedClusterUpdateArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var strategy: Output<UpdateRunStrategyArgs>? = null

    private var updateRunName: Output<String>? = null

    /**
     * @param value The name of the Fleet resource.
     */
    @JvmName("tesdtdaqrcceuwqo")
    public suspend fun fleetName(`value`: Output<String>) {
        this.fleetName = value
    }

    /**
     * @param value The update to be applied to all clusters in the UpdateRun. The managedClusterUpdate can be modified until the run is started.
     */
    @JvmName("sxlfttnnrxestajl")
    public suspend fun managedClusterUpdate(`value`: Output<ManagedClusterUpdateArgs>) {
        this.managedClusterUpdate = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qsbtmkwwbqbnbmyo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The strategy defines the order in which the clusters will be updated.
     * If not set, all members will be updated sequentially. The UpdateRun status will show a single UpdateStage and a single UpdateGroup targeting all members.
     * The strategy of the UpdateRun can be modified until the run is started.
     */
    @JvmName("eymobxtjhqckxidi")
    public suspend fun strategy(`value`: Output<UpdateRunStrategyArgs>) {
        this.strategy = value
    }

    /**
     * @param value The name of the UpdateRun resource.
     */
    @JvmName("obhbxwggkemncnit")
    public suspend fun updateRunName(`value`: Output<String>) {
        this.updateRunName = value
    }

    /**
     * @param value The name of the Fleet resource.
     */
    @JvmName("rttmlmkwcgkntiaa")
    public suspend fun fleetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fleetName = mapped
    }

    /**
     * @param value The update to be applied to all clusters in the UpdateRun. The managedClusterUpdate can be modified until the run is started.
     */
    @JvmName("hnpaurseakpomohb")
    public suspend fun managedClusterUpdate(`value`: ManagedClusterUpdateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedClusterUpdate = mapped
    }

    /**
     * @param argument The update to be applied to all clusters in the UpdateRun. The managedClusterUpdate can be modified until the run is started.
     */
    @JvmName("dedrjidegnlrtqmk")
    public suspend
    fun managedClusterUpdate(argument: suspend ManagedClusterUpdateArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterUpdateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managedClusterUpdate = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("meyqsbyfmqjbnrbf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The strategy defines the order in which the clusters will be updated.
     * If not set, all members will be updated sequentially. The UpdateRun status will show a single UpdateStage and a single UpdateGroup targeting all members.
     * The strategy of the UpdateRun can be modified until the run is started.
     */
    @JvmName("wtomiqamebtscump")
    public suspend fun strategy(`value`: UpdateRunStrategyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.strategy = mapped
    }

    /**
     * @param argument The strategy defines the order in which the clusters will be updated.
     * If not set, all members will be updated sequentially. The UpdateRun status will show a single UpdateStage and a single UpdateGroup targeting all members.
     * The strategy of the UpdateRun can be modified until the run is started.
     */
    @JvmName("smytyjngfgrtoawa")
    public suspend fun strategy(argument: suspend UpdateRunStrategyArgsBuilder.() -> Unit) {
        val toBeMapped = UpdateRunStrategyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.strategy = mapped
    }

    /**
     * @param value The name of the UpdateRun resource.
     */
    @JvmName("oymeiqrawcxpable")
    public suspend fun updateRunName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updateRunName = mapped
    }

    internal fun build(): UpdateRunArgs = UpdateRunArgs(
        fleetName = fleetName,
        managedClusterUpdate = managedClusterUpdate,
        resourceGroupName = resourceGroupName,
        strategy = strategy,
        updateRunName = updateRunName,
    )
}
