@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Network access of key vault. The possible values are `Public` and `Private`. `Public` means the key vault allows public access from all networks. `Private` means the key vault disables public access and enables private link. The default value is `Public`.
 */
public enum class KeyVaultNetworkAccessTypes(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.KeyVaultNetworkAccessTypes,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.KeyVaultNetworkAccessTypes> {
    Public(com.pulumi.azurenative.containerservice.enums.KeyVaultNetworkAccessTypes.Public),
    Private(com.pulumi.azurenative.containerservice.enums.KeyVaultNetworkAccessTypes.Private),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.KeyVaultNetworkAccessTypes =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.KeyVaultNetworkAccessTypes):
            KeyVaultNetworkAccessTypes =
            KeyVaultNetworkAccessTypes.values().first { it.javaValue == javaType }
    }
}
