@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Network plugin used for building the Kubernetes network.
 */
public enum class NetworkPlugin(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.NetworkPlugin,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.NetworkPlugin> {
    /**
     * Use the Azure CNI network plugin. See [Azure CNI (advanced) networking](https://docs.microsoft.com/azure/aks/concepts-network#azure-cni-advanced-networking) for more information.
     */
    Azure(com.pulumi.azurenative.containerservice.enums.NetworkPlugin.Azure),

    /**
     * Use the Kubenet network plugin. See [Kubenet (basic) networking](https://docs.microsoft.com/azure/aks/concepts-network#kubenet-basic-networking) for more information.
     */
    Kubenet(com.pulumi.azurenative.containerservice.enums.NetworkPlugin.Kubenet),

    /**
     * No CNI plugin is pre-installed. See [BYO CNI](https://docs.microsoft.com/en-us/azure/aks/use-byo-cni) for more information.
     */
    None(com.pulumi.azurenative.containerservice.enums.NetworkPlugin.None),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.NetworkPlugin = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.NetworkPlugin):
            NetworkPlugin = NetworkPlugin.values().first { it.javaValue == javaType }
    }
}
