@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Network policy used for building the Kubernetes network.
 */
public enum class NetworkPolicy(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.NetworkPolicy,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.NetworkPolicy> {
    /**
     * Use Calico network policies. See [differences between Azure and Calico policies](https://docs.microsoft.com/azure/aks/use-network-policies#differences-between-azure-and-calico-policies-and-their-capabilities) for more information.
     */
    Calico(com.pulumi.azurenative.containerservice.enums.NetworkPolicy.Calico),

    /**
     * Use Azure network policies. See [differences between Azure and Calico policies](https://docs.microsoft.com/azure/aks/use-network-policies#differences-between-azure-and-calico-policies-and-their-capabilities) for more information.
     */
    Azure(com.pulumi.azurenative.containerservice.enums.NetworkPolicy.Azure),

    /**
     * Use Cilium to enforce network policies. This requires networkDataplane to be 'cilium'.
     */
    Cilium(com.pulumi.azurenative.containerservice.enums.NetworkPolicy.Cilium),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.NetworkPolicy = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.NetworkPolicy):
            NetworkPolicy = NetworkPolicy.values().first { it.javaValue == javaType }
    }
}
