@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'.
 */
public enum class ScaleSetEvictionPolicy(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.ScaleSetEvictionPolicy,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.ScaleSetEvictionPolicy> {
    /**
     * Nodes in the underlying Scale Set of the node pool are deleted when they're evicted.
     */
    Delete(com.pulumi.azurenative.containerservice.enums.ScaleSetEvictionPolicy.Delete),

    /**
     * Nodes in the underlying Scale Set of the node pool are set to the stopped-deallocated state upon eviction. Nodes in the stopped-deallocated state count against your compute quota and can cause issues with cluster scaling or upgrading.
     */
    Deallocate(com.pulumi.azurenative.containerservice.enums.ScaleSetEvictionPolicy.Deallocate),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.ScaleSetEvictionPolicy =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.ScaleSetEvictionPolicy):
            ScaleSetEvictionPolicy = ScaleSetEvictionPolicy.values().first { it.javaValue == javaType }
    }
}
