@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * SSH configuration for Linux-based VMs running on Azure.
 * @property publicKeys The list of SSH public keys used to authenticate with Linux-based VMs. A maximum of 1 key may be specified.
 */
public data class ContainerServiceSshConfigurationArgs(
    public val publicKeys: Output<List<ContainerServiceSshPublicKeyArgs>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshConfigurationArgs =
        com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshConfigurationArgs.builder()
            .publicKeys(
                publicKeys.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ContainerServiceSshConfigurationArgs].
 */
@PulumiTagMarker
public class ContainerServiceSshConfigurationArgsBuilder internal constructor() {
    private var publicKeys: Output<List<ContainerServiceSshPublicKeyArgs>>? = null

    /**
     * @param value The list of SSH public keys used to authenticate with Linux-based VMs. A maximum of 1 key may be specified.
     */
    @JvmName("ahvdbsbamgvuldwx")
    public suspend fun publicKeys(`value`: Output<List<ContainerServiceSshPublicKeyArgs>>) {
        this.publicKeys = value
    }

    @JvmName("huhdvnmwcbpnkudu")
    public suspend fun publicKeys(vararg values: Output<ContainerServiceSshPublicKeyArgs>) {
        this.publicKeys = Output.all(values.asList())
    }

    /**
     * @param values The list of SSH public keys used to authenticate with Linux-based VMs. A maximum of 1 key may be specified.
     */
    @JvmName("nyxlvpagauosodfx")
    public suspend fun publicKeys(values: List<Output<ContainerServiceSshPublicKeyArgs>>) {
        this.publicKeys = Output.all(values)
    }

    /**
     * @param value The list of SSH public keys used to authenticate with Linux-based VMs. A maximum of 1 key may be specified.
     */
    @JvmName("gydtckuxqrbcimfr")
    public suspend fun publicKeys(`value`: List<ContainerServiceSshPublicKeyArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicKeys = mapped
    }

    /**
     * @param argument The list of SSH public keys used to authenticate with Linux-based VMs. A maximum of 1 key may be specified.
     */
    @JvmName("utsalodkpdbjuuyr")
    public suspend
    fun publicKeys(argument: List<suspend ContainerServiceSshPublicKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerServiceSshPublicKeyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.publicKeys = mapped
    }

    /**
     * @param argument The list of SSH public keys used to authenticate with Linux-based VMs. A maximum of 1 key may be specified.
     */
    @JvmName("iilwrtmvfwniujhv")
    public suspend fun publicKeys(
        vararg
        argument: suspend ContainerServiceSshPublicKeyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ContainerServiceSshPublicKeyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.publicKeys = mapped
    }

    /**
     * @param argument The list of SSH public keys used to authenticate with Linux-based VMs. A maximum of 1 key may be specified.
     */
    @JvmName("ieeiwtskemumtakf")
    public suspend
    fun publicKeys(argument: suspend ContainerServiceSshPublicKeyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerServiceSshPublicKeyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.publicKeys = mapped
    }

    /**
     * @param values The list of SSH public keys used to authenticate with Linux-based VMs. A maximum of 1 key may be specified.
     */
    @JvmName("pghpcogwmvqjyujs")
    public suspend fun publicKeys(vararg values: ContainerServiceSshPublicKeyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicKeys = mapped
    }

    internal fun build(): ContainerServiceSshConfigurationArgs = ContainerServiceSshConfigurationArgs(
        publicKeys = publicKeys ?: throw PulumiNullFieldException("publicKeys"),
    )
}
