@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.GetOpenShiftManagedClusterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property resourceName The name of the OpenShift managed cluster resource.
 */
public data class GetOpenShiftManagedClusterPlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.GetOpenShiftManagedClusterPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.GetOpenShiftManagedClusterPlainArgs =
        com.pulumi.azurenative.containerservice.inputs.GetOpenShiftManagedClusterPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOpenShiftManagedClusterPlainArgs].
 */
@PulumiTagMarker
public class GetOpenShiftManagedClusterPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("pletdvoajtnfugml")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the OpenShift managed cluster resource.
     */
    @JvmName("axmmmaqxnweooxpf")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetOpenShiftManagedClusterPlainArgs = GetOpenShiftManagedClusterPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
