@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAADProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * For more details see [managed AAD on AKS](https://docs.microsoft.com/azure/aks/managed-aad).
 * @property adminGroupObjectIDs The list of AAD group object IDs that will have admin role of the cluster.
 * @property clientAppID (DEPRECATED) The client AAD application ID. Learn more at https://aka.ms/aks/aad-legacy.
 * @property enableAzureRBAC Whether to enable Azure RBAC for Kubernetes authorization.
 * @property managed Whether to enable managed AAD.
 * @property serverAppID (DEPRECATED) The server AAD application ID. Learn more at https://aka.ms/aks/aad-legacy.
 * @property serverAppSecret (DEPRECATED) The server AAD application secret. Learn more at https://aka.ms/aks/aad-legacy.
 * @property tenantID The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription.
 */
public data class ManagedClusterAADProfileArgs(
    public val adminGroupObjectIDs: Output<List<String>>? = null,
    public val clientAppID: Output<String>? = null,
    public val enableAzureRBAC: Output<Boolean>? = null,
    public val managed: Output<Boolean>? = null,
    public val serverAppID: Output<String>? = null,
    public val serverAppSecret: Output<String>? = null,
    public val tenantID: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterAADProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.ManagedClusterAADProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterAADProfileArgs.builder()
            .adminGroupObjectIDs(adminGroupObjectIDs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .clientAppID(clientAppID?.applyValue({ args0 -> args0 }))
            .enableAzureRBAC(enableAzureRBAC?.applyValue({ args0 -> args0 }))
            .managed(managed?.applyValue({ args0 -> args0 }))
            .serverAppID(serverAppID?.applyValue({ args0 -> args0 }))
            .serverAppSecret(serverAppSecret?.applyValue({ args0 -> args0 }))
            .tenantID(tenantID?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedClusterAADProfileArgs].
 */
@PulumiTagMarker
public class ManagedClusterAADProfileArgsBuilder internal constructor() {
    private var adminGroupObjectIDs: Output<List<String>>? = null

    private var clientAppID: Output<String>? = null

    private var enableAzureRBAC: Output<Boolean>? = null

    private var managed: Output<Boolean>? = null

    private var serverAppID: Output<String>? = null

    private var serverAppSecret: Output<String>? = null

    private var tenantID: Output<String>? = null

    /**
     * @param value The list of AAD group object IDs that will have admin role of the cluster.
     */
    @JvmName("vmdbdxwjqvxxjsrm")
    public suspend fun adminGroupObjectIDs(`value`: Output<List<String>>) {
        this.adminGroupObjectIDs = value
    }

    @JvmName("tjjaxtbnoxsbmaro")
    public suspend fun adminGroupObjectIDs(vararg values: Output<String>) {
        this.adminGroupObjectIDs = Output.all(values.asList())
    }

    /**
     * @param values The list of AAD group object IDs that will have admin role of the cluster.
     */
    @JvmName("nnefrvkwisudkgxq")
    public suspend fun adminGroupObjectIDs(values: List<Output<String>>) {
        this.adminGroupObjectIDs = Output.all(values)
    }

    /**
     * @param value (DEPRECATED) The client AAD application ID. Learn more at https://aka.ms/aks/aad-legacy.
     */
    @JvmName("wddnpgcrbbknfbdt")
    public suspend fun clientAppID(`value`: Output<String>) {
        this.clientAppID = value
    }

    /**
     * @param value Whether to enable Azure RBAC for Kubernetes authorization.
     */
    @JvmName("ajiabgteyttwkqwh")
    public suspend fun enableAzureRBAC(`value`: Output<Boolean>) {
        this.enableAzureRBAC = value
    }

    /**
     * @param value Whether to enable managed AAD.
     */
    @JvmName("xtgvetwuvwljtrxe")
    public suspend fun managed(`value`: Output<Boolean>) {
        this.managed = value
    }

    /**
     * @param value (DEPRECATED) The server AAD application ID. Learn more at https://aka.ms/aks/aad-legacy.
     */
    @JvmName("rvfejevvenfrvaek")
    public suspend fun serverAppID(`value`: Output<String>) {
        this.serverAppID = value
    }

    /**
     * @param value (DEPRECATED) The server AAD application secret. Learn more at https://aka.ms/aks/aad-legacy.
     */
    @JvmName("rbsrjrsomavgpues")
    public suspend fun serverAppSecret(`value`: Output<String>) {
        this.serverAppSecret = value
    }

    /**
     * @param value The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription.
     */
    @JvmName("yhgpudxxbadidqyu")
    public suspend fun tenantID(`value`: Output<String>) {
        this.tenantID = value
    }

    /**
     * @param value The list of AAD group object IDs that will have admin role of the cluster.
     */
    @JvmName("eyngvhbjvtqpgrmn")
    public suspend fun adminGroupObjectIDs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminGroupObjectIDs = mapped
    }

    /**
     * @param values The list of AAD group object IDs that will have admin role of the cluster.
     */
    @JvmName("wpkbxugkynyeoymh")
    public suspend fun adminGroupObjectIDs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adminGroupObjectIDs = mapped
    }

    /**
     * @param value (DEPRECATED) The client AAD application ID. Learn more at https://aka.ms/aks/aad-legacy.
     */
    @JvmName("kscxlyswuufrgbwh")
    public suspend fun clientAppID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientAppID = mapped
    }

    /**
     * @param value Whether to enable Azure RBAC for Kubernetes authorization.
     */
    @JvmName("wbpxkwjumvoilltw")
    public suspend fun enableAzureRBAC(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAzureRBAC = mapped
    }

    /**
     * @param value Whether to enable managed AAD.
     */
    @JvmName("anpgptrmcbnnydgg")
    public suspend fun managed(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managed = mapped
    }

    /**
     * @param value (DEPRECATED) The server AAD application ID. Learn more at https://aka.ms/aks/aad-legacy.
     */
    @JvmName("pwqjnogtldrtlmwb")
    public suspend fun serverAppID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverAppID = mapped
    }

    /**
     * @param value (DEPRECATED) The server AAD application secret. Learn more at https://aka.ms/aks/aad-legacy.
     */
    @JvmName("mujjxgkftekcdflh")
    public suspend fun serverAppSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverAppSecret = mapped
    }

    /**
     * @param value The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription.
     */
    @JvmName("qcowqtmhvagkubop")
    public suspend fun tenantID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantID = mapped
    }

    internal fun build(): ManagedClusterAADProfileArgs = ManagedClusterAADProfileArgs(
        adminGroupObjectIDs = adminGroupObjectIDs,
        clientAppID = clientAppID,
        enableAzureRBAC = enableAzureRBAC,
        managed = managed,
        serverAppID = serverAppID,
        serverAppSecret = serverAppSecret,
        tenantID = tenantID,
    )
}
