@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAutoUpgradeProfileArgs.builder
import com.pulumi.azurenative.containerservice.kotlin.enums.UpgradeChannel
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Auto upgrade profile for a managed cluster.
 * @property upgradeChannel For more information see [setting the AKS cluster auto-upgrade channel](https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel).
 */
public data class ManagedClusterAutoUpgradeProfileArgs(
    public val upgradeChannel: Output<Either<String, UpgradeChannel>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterAutoUpgradeProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterAutoUpgradeProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterAutoUpgradeProfileArgs.builder()
            .upgradeChannel(
                upgradeChannel?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedClusterAutoUpgradeProfileArgs].
 */
@PulumiTagMarker
public class ManagedClusterAutoUpgradeProfileArgsBuilder internal constructor() {
    private var upgradeChannel: Output<Either<String, UpgradeChannel>>? = null

    /**
     * @param value For more information see [setting the AKS cluster auto-upgrade channel](https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel).
     */
    @JvmName("wridqkatfsajdufk")
    public suspend fun upgradeChannel(`value`: Output<Either<String, UpgradeChannel>>) {
        this.upgradeChannel = value
    }

    /**
     * @param value For more information see [setting the AKS cluster auto-upgrade channel](https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel).
     */
    @JvmName("jeattwvrhcubjrnc")
    public suspend fun upgradeChannel(`value`: Either<String, UpgradeChannel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upgradeChannel = mapped
    }

    /**
     * @param value For more information see [setting the AKS cluster auto-upgrade channel](https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel).
     */
    @JvmName("aqnugeldnnjobhna")
    public fun upgradeChannel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, UpgradeChannel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.upgradeChannel = mapped
    }

    /**
     * @param value For more information see [setting the AKS cluster auto-upgrade channel](https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel).
     */
    @JvmName("ajygoxncsltjselm")
    public fun upgradeChannel(`value`: UpgradeChannel) {
        val toBeMapped = Either.ofRight<String, UpgradeChannel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.upgradeChannel = mapped
    }

    internal fun build(): ManagedClusterAutoUpgradeProfileArgs = ManagedClusterAutoUpgradeProfileArgs(
        upgradeChannel = upgradeChannel,
    )
}
