@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAzureMonitorProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Monitor addon profiles for monitoring the managed cluster.
 * @property metrics Metrics profile for the Azure Monitor managed service for Prometheus addon. Collect out-of-the-box Kubernetes infrastructure metrics to send to an Azure Monitor Workspace and configure additional scraping for custom targets. See aka.ms/AzureManagedPrometheus for an overview.
 */
public data class ManagedClusterAzureMonitorProfileArgs(
    public val metrics: Output<ManagedClusterAzureMonitorProfileMetricsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterAzureMonitorProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterAzureMonitorProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterAzureMonitorProfileArgs.builder()
            .metrics(metrics?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ManagedClusterAzureMonitorProfileArgs].
 */
@PulumiTagMarker
public class ManagedClusterAzureMonitorProfileArgsBuilder internal constructor() {
    private var metrics: Output<ManagedClusterAzureMonitorProfileMetricsArgs>? = null

    /**
     * @param value Metrics profile for the Azure Monitor managed service for Prometheus addon. Collect out-of-the-box Kubernetes infrastructure metrics to send to an Azure Monitor Workspace and configure additional scraping for custom targets. See aka.ms/AzureManagedPrometheus for an overview.
     */
    @JvmName("innbcyfpmrhijhlm")
    public suspend fun metrics(`value`: Output<ManagedClusterAzureMonitorProfileMetricsArgs>) {
        this.metrics = value
    }

    /**
     * @param value Metrics profile for the Azure Monitor managed service for Prometheus addon. Collect out-of-the-box Kubernetes infrastructure metrics to send to an Azure Monitor Workspace and configure additional scraping for custom targets. See aka.ms/AzureManagedPrometheus for an overview.
     */
    @JvmName("fjlbejpiytpkmhmo")
    public suspend fun metrics(`value`: ManagedClusterAzureMonitorProfileMetricsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metrics = mapped
    }

    /**
     * @param argument Metrics profile for the Azure Monitor managed service for Prometheus addon. Collect out-of-the-box Kubernetes infrastructure metrics to send to an Azure Monitor Workspace and configure additional scraping for custom targets. See aka.ms/AzureManagedPrometheus for an overview.
     */
    @JvmName("mnsmdprgjkkefcei")
    public suspend
    fun metrics(argument: suspend ManagedClusterAzureMonitorProfileMetricsArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterAzureMonitorProfileMetricsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    internal fun build(): ManagedClusterAzureMonitorProfileArgs =
        ManagedClusterAzureMonitorProfileArgs(
            metrics = metrics,
        )
}
