@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.PowerStateArgs.builder
import com.pulumi.azurenative.containerservice.kotlin.enums.Code
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the Power State of the cluster
 * @property code Tells whether the cluster is Running or Stopped
 */
public data class PowerStateArgs(
    public val code: Output<Either<String, Code>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.PowerStateArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.PowerStateArgs =
        com.pulumi.azurenative.containerservice.inputs.PowerStateArgs.builder()
            .code(
                code?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PowerStateArgs].
 */
@PulumiTagMarker
public class PowerStateArgsBuilder internal constructor() {
    private var code: Output<Either<String, Code>>? = null

    /**
     * @param value Tells whether the cluster is Running or Stopped
     */
    @JvmName("saschlmxhfnbckfx")
    public suspend fun code(`value`: Output<Either<String, Code>>) {
        this.code = value
    }

    /**
     * @param value Tells whether the cluster is Running or Stopped
     */
    @JvmName("jctkjijigwhvkgqh")
    public suspend fun code(`value`: Either<String, Code>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value Tells whether the cluster is Running or Stopped
     */
    @JvmName("ufusvpboeuxhogdi")
    public fun code(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Code>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value Tells whether the cluster is Running or Stopped
     */
    @JvmName("fdsvwxrimuokumwh")
    public fun code(`value`: Code) {
        val toBeMapped = Either.ofRight<String, Code>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.code = mapped
    }

    internal fun build(): PowerStateArgs = PowerStateArgs(
        code = code,
    )
}
