@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.PurchasePlanArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Used for establishing the purchase context of any 3rd Party artifact through MarketPlace.
 * @property name The plan ID.
 * @property product Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
 * @property promotionCode The promotion code.
 * @property publisher The plan ID.
 */
public data class PurchasePlanArgs(
    public val name: Output<String>? = null,
    public val product: Output<String>? = null,
    public val promotionCode: Output<String>? = null,
    public val publisher: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.PurchasePlanArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.PurchasePlanArgs =
        com.pulumi.azurenative.containerservice.inputs.PurchasePlanArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .product(product?.applyValue({ args0 -> args0 }))
            .promotionCode(promotionCode?.applyValue({ args0 -> args0 }))
            .publisher(publisher?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PurchasePlanArgs].
 */
@PulumiTagMarker
public class PurchasePlanArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var product: Output<String>? = null

    private var promotionCode: Output<String>? = null

    private var publisher: Output<String>? = null

    /**
     * @param value The plan ID.
     */
    @JvmName("fdhlquqqjkdwrath")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
     */
    @JvmName("fploftgaupavuwkp")
    public suspend fun product(`value`: Output<String>) {
        this.product = value
    }

    /**
     * @param value The promotion code.
     */
    @JvmName("xhpmkvsteoyrokkc")
    public suspend fun promotionCode(`value`: Output<String>) {
        this.promotionCode = value
    }

    /**
     * @param value The plan ID.
     */
    @JvmName("cbnjnlwwcnlkrpnu")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value The plan ID.
     */
    @JvmName("xbyjqpybmuxoddkh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
     */
    @JvmName("bfvpsnjmhjenfvmw")
    public suspend fun product(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.product = mapped
    }

    /**
     * @param value The promotion code.
     */
    @JvmName("rovhmnmvfyrkbabf")
    public suspend fun promotionCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.promotionCode = mapped
    }

    /**
     * @param value The plan ID.
     */
    @JvmName("xctavvcmhyskxjai")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    internal fun build(): PurchasePlanArgs = PurchasePlanArgs(
        name = name,
        product = product,
        promotionCode = promotionCode,
        publisher = publisher,
    )
}
