@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.TimeInWeekArgs.builder
import com.pulumi.azurenative.containerservice.kotlin.enums.WeekDay
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Time in a week.
 * @property day The day of the week.
 * @property hourSlots Each integer hour represents a time range beginning at 0m after the hour ending at the next hour (non-inclusive). 0 corresponds to 00:00 UTC, 23 corresponds to 23:00 UTC. Specifying [0, 1] means the 00:00 - 02:00 UTC time range.
 */
public data class TimeInWeekArgs(
    public val day: Output<Either<String, WeekDay>>? = null,
    public val hourSlots: Output<List<Int>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.TimeInWeekArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.TimeInWeekArgs =
        com.pulumi.azurenative.containerservice.inputs.TimeInWeekArgs.builder()
            .day(
                day?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .hourSlots(hourSlots?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [TimeInWeekArgs].
 */
@PulumiTagMarker
public class TimeInWeekArgsBuilder internal constructor() {
    private var day: Output<Either<String, WeekDay>>? = null

    private var hourSlots: Output<List<Int>>? = null

    /**
     * @param value The day of the week.
     */
    @JvmName("rscpribioeycfutt")
    public suspend fun day(`value`: Output<Either<String, WeekDay>>) {
        this.day = value
    }

    /**
     * @param value Each integer hour represents a time range beginning at 0m after the hour ending at the next hour (non-inclusive). 0 corresponds to 00:00 UTC, 23 corresponds to 23:00 UTC. Specifying [0, 1] means the 00:00 - 02:00 UTC time range.
     */
    @JvmName("malsytaiiwsuuwfs")
    public suspend fun hourSlots(`value`: Output<List<Int>>) {
        this.hourSlots = value
    }

    @JvmName("wnnvemaweonleyou")
    public suspend fun hourSlots(vararg values: Output<Int>) {
        this.hourSlots = Output.all(values.asList())
    }

    /**
     * @param values Each integer hour represents a time range beginning at 0m after the hour ending at the next hour (non-inclusive). 0 corresponds to 00:00 UTC, 23 corresponds to 23:00 UTC. Specifying [0, 1] means the 00:00 - 02:00 UTC time range.
     */
    @JvmName("pbetbmqgxwejufyq")
    public suspend fun hourSlots(values: List<Output<Int>>) {
        this.hourSlots = Output.all(values)
    }

    /**
     * @param value The day of the week.
     */
    @JvmName("bdkhydlocmbvagyd")
    public suspend fun day(`value`: Either<String, WeekDay>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.day = mapped
    }

    /**
     * @param value The day of the week.
     */
    @JvmName("kqekjmpirxtipndu")
    public fun day(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WeekDay>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.day = mapped
    }

    /**
     * @param value The day of the week.
     */
    @JvmName("rwoafxopidivdvlv")
    public fun day(`value`: WeekDay) {
        val toBeMapped = Either.ofRight<String, WeekDay>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.day = mapped
    }

    /**
     * @param value Each integer hour represents a time range beginning at 0m after the hour ending at the next hour (non-inclusive). 0 corresponds to 00:00 UTC, 23 corresponds to 23:00 UTC. Specifying [0, 1] means the 00:00 - 02:00 UTC time range.
     */
    @JvmName("mnlfqhrybewovogr")
    public suspend fun hourSlots(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hourSlots = mapped
    }

    /**
     * @param values Each integer hour represents a time range beginning at 0m after the hour ending at the next hour (non-inclusive). 0 corresponds to 00:00 UTC, 23 corresponds to 23:00 UTC. Specifying [0, 1] means the 00:00 - 02:00 UTC time range.
     */
    @JvmName("ietdbmwfpmtwdclx")
    public suspend fun hourSlots(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hourSlots = mapped
    }

    internal fun build(): TimeInWeekArgs = TimeInWeekArgs(
        day = day,
        hourSlots = hourSlots,
    )
}
