@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Azure Key Vault key management service settings for the security profile.
 * @property enabled Whether to enable Azure Key Vault key management service. The default is false.
 * @property keyId Identifier of Azure Key Vault key. See [key identifier format](https://docs.microsoft.com/en-us/azure/key-vault/general/about-keys-secrets-certificates#vault-name-and-object-name) for more details. When Azure Key Vault key management service is enabled, this field is required and must be a valid key identifier. When Azure Key Vault key management service is disabled, leave the field empty.
 * @property keyVaultNetworkAccess Network access of key vault. The possible values are `Public` and `Private`. `Public` means the key vault allows public access from all networks. `Private` means the key vault disables public access and enables private link. The default value is `Public`.
 * @property keyVaultResourceId Resource ID of key vault. When keyVaultNetworkAccess is `Private`, this field is required and must be a valid resource ID. When keyVaultNetworkAccess is `Public`, leave the field empty.
 */
public data class AzureKeyVaultKmsResponse(
    public val enabled: Boolean? = null,
    public val keyId: String? = null,
    public val keyVaultNetworkAccess: String? = null,
    public val keyVaultResourceId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.AzureKeyVaultKmsResponse):
            AzureKeyVaultKmsResponse = AzureKeyVaultKmsResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            keyId = javaType.keyId().map({ args0 -> args0 }).orElse(null),
            keyVaultNetworkAccess = javaType.keyVaultNetworkAccess().map({ args0 -> args0 }).orElse(null),
            keyVaultResourceId = javaType.keyVaultResourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
