@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Contains information about SSH certificate public key data.
 * @property keyData Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with or without headers.
 */
public data class ContainerServiceSshPublicKeyResponse(
    public val keyData: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ContainerServiceSshPublicKeyResponse):
            ContainerServiceSshPublicKeyResponse = ContainerServiceSshPublicKeyResponse(
            keyData = javaType.keyData(),
        )
    }
}
