@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Suppress

/**
 * Azure Monitor addon profiles for monitoring the managed cluster.
 * @property metrics Metrics profile for the Azure Monitor managed service for Prometheus addon. Collect out-of-the-box Kubernetes infrastructure metrics to send to an Azure Monitor Workspace and configure additional scraping for custom targets. See aka.ms/AzureManagedPrometheus for an overview.
 */
public data class ManagedClusterAzureMonitorProfileResponse(
    public val metrics: ManagedClusterAzureMonitorProfileMetricsResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterAzureMonitorProfileResponse):
            ManagedClusterAzureMonitorProfileResponse = ManagedClusterAzureMonitorProfileResponse(
            metrics = javaType.metrics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterAzureMonitorProfileMetricsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
