@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 * Profile of the managed cluster load balancer.
 * @property allocatedOutboundPorts The desired number of allocated SNAT ports per VM. Allowed values are in the range of 0 to 64000 (inclusive). The default value is 0 which results in Azure dynamically allocating ports.
 * @property effectiveOutboundIPs The effective outbound IP resources of the cluster load balancer.
 * @property enableMultipleStandardLoadBalancers Enable multiple standard load balancers per AKS cluster or not.
 * @property idleTimeoutInMinutes Desired outbound flow idle timeout in minutes. Allowed values are in the range of 4 to 120 (inclusive). The default value is 30 minutes.
 * @property managedOutboundIPs Desired managed outbound IPs for the cluster load balancer.
 * @property outboundIPPrefixes Desired outbound IP Prefix resources for the cluster load balancer.
 * @property outboundIPs Desired outbound IP resources for the cluster load balancer.
 */
public data class ManagedClusterLoadBalancerProfileResponse(
    public val allocatedOutboundPorts: Int? = null,
    public val effectiveOutboundIPs: List<ResourceReferenceResponse>? = null,
    public val enableMultipleStandardLoadBalancers: Boolean? = null,
    public val idleTimeoutInMinutes: Int? = null,
    public val managedOutboundIPs: ManagedClusterLoadBalancerProfileResponseManagedOutboundIPs? =
        null,
    public val outboundIPPrefixes: ManagedClusterLoadBalancerProfileResponseOutboundIPPrefixes? =
        null,
    public val outboundIPs: ManagedClusterLoadBalancerProfileResponseOutboundIPs? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterLoadBalancerProfileResponse):
            ManagedClusterLoadBalancerProfileResponse = ManagedClusterLoadBalancerProfileResponse(
            allocatedOutboundPorts = javaType.allocatedOutboundPorts().map({ args0 -> args0 }).orElse(null),
            effectiveOutboundIPs = javaType.effectiveOutboundIPs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            enableMultipleStandardLoadBalancers = javaType.enableMultipleStandardLoadBalancers().map({ args0 ->
                args0
            }).orElse(null),
            idleTimeoutInMinutes = javaType.idleTimeoutInMinutes().map({ args0 -> args0 }).orElse(null),
            managedOutboundIPs = javaType.managedOutboundIPs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterLoadBalancerProfileResponseManagedOutboundIPs.Companion.toKotlin(args0)
                })
            }).orElse(null),
            outboundIPPrefixes = javaType.outboundIPPrefixes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterLoadBalancerProfileResponseOutboundIPPrefixes.Companion.toKotlin(args0)
                })
            }).orElse(null),
            outboundIPs = javaType.outboundIPs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterLoadBalancerProfileResponseOutboundIPs.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
