@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Desired outbound IP resources for the cluster load balancer.
 * @property publicIPs A list of public IP resources.
 */
public data class ManagedClusterLoadBalancerProfileResponseOutboundIPs(
    public val publicIPs: List<ResourceReferenceResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterLoadBalancerProfileResponseOutboundIPs):
            ManagedClusterLoadBalancerProfileResponseOutboundIPs =
            ManagedClusterLoadBalancerProfileResponseOutboundIPs(
                publicIPs = javaType.publicIPs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.containerservice.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
