@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Suppress

/**
 * Security profile for the container service cluster.
 * @property azureKeyVaultKms Azure Key Vault [key management service](https://kubernetes.io/docs/tasks/administer-cluster/kms-provider/) settings for the security profile.
 * @property defender Microsoft Defender settings for the security profile.
 * @property imageCleaner Image Cleaner settings for the security profile.
 * @property workloadIdentity Workload identity settings for the security profile. Workload identity enables Kubernetes applications to access Azure cloud resources securely with Azure AD. See https://aka.ms/aks/wi for more details.
 */
public data class ManagedClusterSecurityProfileResponse(
    public val azureKeyVaultKms: AzureKeyVaultKmsResponse? = null,
    public val defender: ManagedClusterSecurityProfileDefenderResponse? = null,
    public val imageCleaner: ManagedClusterSecurityProfileImageCleanerResponse? = null,
    public val workloadIdentity: ManagedClusterSecurityProfileWorkloadIdentityResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterSecurityProfileResponse):
            ManagedClusterSecurityProfileResponse = ManagedClusterSecurityProfileResponse(
            azureKeyVaultKms = javaType.azureKeyVaultKms().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.AzureKeyVaultKmsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            defender = javaType.defender().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterSecurityProfileDefenderResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            imageCleaner = javaType.imageCleaner().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterSecurityProfileImageCleanerResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            workloadIdentity = javaType.workloadIdentity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterSecurityProfileWorkloadIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
