@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the configuration of the identity providers to be used in the OpenShift cluster.
 * @property name Name of the provider.
 * @property provider Configuration of the provider.
 */
public data class OpenShiftManagedClusterIdentityProviderResponse(
    public val name: String? = null,
    public val provider: OpenShiftManagedClusterAADIdentityProviderResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.OpenShiftManagedClusterIdentityProviderResponse):
            OpenShiftManagedClusterIdentityProviderResponse =
            OpenShiftManagedClusterIdentityProviderResponse(
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                provider = javaType.provider().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.containerservice.kotlin.outputs.OpenShiftManagedClusterAADIdentityProviderResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
