@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Sysctl settings for Linux agent nodes.
 * @property fsAioMaxNr Sysctl setting fs.aio-max-nr.
 * @property fsFileMax Sysctl setting fs.file-max.
 * @property fsInotifyMaxUserWatches Sysctl setting fs.inotify.max_user_watches.
 * @property fsNrOpen Sysctl setting fs.nr_open.
 * @property kernelThreadsMax Sysctl setting kernel.threads-max.
 * @property netCoreNetdevMaxBacklog Sysctl setting net.core.netdev_max_backlog.
 * @property netCoreOptmemMax Sysctl setting net.core.optmem_max.
 * @property netCoreRmemDefault Sysctl setting net.core.rmem_default.
 * @property netCoreRmemMax Sysctl setting net.core.rmem_max.
 * @property netCoreSomaxconn Sysctl setting net.core.somaxconn.
 * @property netCoreWmemDefault Sysctl setting net.core.wmem_default.
 * @property netCoreWmemMax Sysctl setting net.core.wmem_max.
 * @property netIpv4IpLocalPortRange Sysctl setting net.ipv4.ip_local_port_range.
 * @property netIpv4NeighDefaultGcThresh1 Sysctl setting net.ipv4.neigh.default.gc_thresh1.
 * @property netIpv4NeighDefaultGcThresh2 Sysctl setting net.ipv4.neigh.default.gc_thresh2.
 * @property netIpv4NeighDefaultGcThresh3 Sysctl setting net.ipv4.neigh.default.gc_thresh3.
 * @property netIpv4TcpFinTimeout Sysctl setting net.ipv4.tcp_fin_timeout.
 * @property netIpv4TcpKeepaliveProbes Sysctl setting net.ipv4.tcp_keepalive_probes.
 * @property netIpv4TcpKeepaliveTime Sysctl setting net.ipv4.tcp_keepalive_time.
 * @property netIpv4TcpMaxSynBacklog Sysctl setting net.ipv4.tcp_max_syn_backlog.
 * @property netIpv4TcpMaxTwBuckets Sysctl setting net.ipv4.tcp_max_tw_buckets.
 * @property netIpv4TcpTwReuse Sysctl setting net.ipv4.tcp_tw_reuse.
 * @property netIpv4TcpkeepaliveIntvl Sysctl setting net.ipv4.tcp_keepalive_intvl.
 * @property netNetfilterNfConntrackBuckets Sysctl setting net.netfilter.nf_conntrack_buckets.
 * @property netNetfilterNfConntrackMax Sysctl setting net.netfilter.nf_conntrack_max.
 * @property vmMaxMapCount Sysctl setting vm.max_map_count.
 * @property vmSwappiness Sysctl setting vm.swappiness.
 * @property vmVfsCachePressure Sysctl setting vm.vfs_cache_pressure.
 */
public data class SysctlConfigResponse(
    public val fsAioMaxNr: Int? = null,
    public val fsFileMax: Int? = null,
    public val fsInotifyMaxUserWatches: Int? = null,
    public val fsNrOpen: Int? = null,
    public val kernelThreadsMax: Int? = null,
    public val netCoreNetdevMaxBacklog: Int? = null,
    public val netCoreOptmemMax: Int? = null,
    public val netCoreRmemDefault: Int? = null,
    public val netCoreRmemMax: Int? = null,
    public val netCoreSomaxconn: Int? = null,
    public val netCoreWmemDefault: Int? = null,
    public val netCoreWmemMax: Int? = null,
    public val netIpv4IpLocalPortRange: String? = null,
    public val netIpv4NeighDefaultGcThresh1: Int? = null,
    public val netIpv4NeighDefaultGcThresh2: Int? = null,
    public val netIpv4NeighDefaultGcThresh3: Int? = null,
    public val netIpv4TcpFinTimeout: Int? = null,
    public val netIpv4TcpKeepaliveProbes: Int? = null,
    public val netIpv4TcpKeepaliveTime: Int? = null,
    public val netIpv4TcpMaxSynBacklog: Int? = null,
    public val netIpv4TcpMaxTwBuckets: Int? = null,
    public val netIpv4TcpTwReuse: Boolean? = null,
    public val netIpv4TcpkeepaliveIntvl: Int? = null,
    public val netNetfilterNfConntrackBuckets: Int? = null,
    public val netNetfilterNfConntrackMax: Int? = null,
    public val vmMaxMapCount: Int? = null,
    public val vmSwappiness: Int? = null,
    public val vmVfsCachePressure: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.SysctlConfigResponse):
            SysctlConfigResponse = SysctlConfigResponse(
            fsAioMaxNr = javaType.fsAioMaxNr().map({ args0 -> args0 }).orElse(null),
            fsFileMax = javaType.fsFileMax().map({ args0 -> args0 }).orElse(null),
            fsInotifyMaxUserWatches = javaType.fsInotifyMaxUserWatches().map({ args0 -> args0 }).orElse(null),
            fsNrOpen = javaType.fsNrOpen().map({ args0 -> args0 }).orElse(null),
            kernelThreadsMax = javaType.kernelThreadsMax().map({ args0 -> args0 }).orElse(null),
            netCoreNetdevMaxBacklog = javaType.netCoreNetdevMaxBacklog().map({ args0 -> args0 }).orElse(null),
            netCoreOptmemMax = javaType.netCoreOptmemMax().map({ args0 -> args0 }).orElse(null),
            netCoreRmemDefault = javaType.netCoreRmemDefault().map({ args0 -> args0 }).orElse(null),
            netCoreRmemMax = javaType.netCoreRmemMax().map({ args0 -> args0 }).orElse(null),
            netCoreSomaxconn = javaType.netCoreSomaxconn().map({ args0 -> args0 }).orElse(null),
            netCoreWmemDefault = javaType.netCoreWmemDefault().map({ args0 -> args0 }).orElse(null),
            netCoreWmemMax = javaType.netCoreWmemMax().map({ args0 -> args0 }).orElse(null),
            netIpv4IpLocalPortRange = javaType.netIpv4IpLocalPortRange().map({ args0 -> args0 }).orElse(null),
            netIpv4NeighDefaultGcThresh1 = javaType.netIpv4NeighDefaultGcThresh1().map({ args0 ->
                args0
            }).orElse(null),
            netIpv4NeighDefaultGcThresh2 = javaType.netIpv4NeighDefaultGcThresh2().map({ args0 ->
                args0
            }).orElse(null),
            netIpv4NeighDefaultGcThresh3 = javaType.netIpv4NeighDefaultGcThresh3().map({ args0 ->
                args0
            }).orElse(null),
            netIpv4TcpFinTimeout = javaType.netIpv4TcpFinTimeout().map({ args0 -> args0 }).orElse(null),
            netIpv4TcpKeepaliveProbes = javaType.netIpv4TcpKeepaliveProbes().map({ args0 ->
                args0
            }).orElse(null),
            netIpv4TcpKeepaliveTime = javaType.netIpv4TcpKeepaliveTime().map({ args0 -> args0 }).orElse(null),
            netIpv4TcpMaxSynBacklog = javaType.netIpv4TcpMaxSynBacklog().map({ args0 -> args0 }).orElse(null),
            netIpv4TcpMaxTwBuckets = javaType.netIpv4TcpMaxTwBuckets().map({ args0 -> args0 }).orElse(null),
            netIpv4TcpTwReuse = javaType.netIpv4TcpTwReuse().map({ args0 -> args0 }).orElse(null),
            netIpv4TcpkeepaliveIntvl = javaType.netIpv4TcpkeepaliveIntvl().map({ args0 -> args0 }).orElse(null),
            netNetfilterNfConntrackBuckets = javaType.netNetfilterNfConntrackBuckets().map({ args0 ->
                args0
            }).orElse(null),
            netNetfilterNfConntrackMax = javaType.netNetfilterNfConntrackMax().map({ args0 ->
                args0
            }).orElse(null),
            vmMaxMapCount = javaType.vmMaxMapCount().map({ args0 -> args0 }).orElse(null),
            vmSwappiness = javaType.vmSwappiness().map({ args0 -> args0 }).orElse(null),
            vmVfsCachePressure = javaType.vmVfsCachePressure().map({ args0 -> args0 }).orElse(null),
        )
    }
}
