@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Windows gMSA Profile in the managed cluster.
 * @property dnsServer Specifies the DNS server for Windows gMSA. <br><br> Set it to empty if you have configured the DNS server in the vnet which is used to create the managed cluster.
 * @property enabled Specifies whether to enable Windows gMSA in the managed cluster.
 * @property rootDomainName Specifies the root domain name for Windows gMSA. <br><br> Set it to empty if you have configured the DNS server in the vnet which is used to create the managed cluster.
 */
public data class WindowsGmsaProfileResponse(
    public val dnsServer: String? = null,
    public val enabled: Boolean? = null,
    public val rootDomainName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.WindowsGmsaProfileResponse):
            WindowsGmsaProfileResponse = WindowsGmsaProfileResponse(
            dnsServer = javaType.dnsServer().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            rootDomainName = javaType.rootDomainName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
