@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.outputs

import kotlin.Double
import kotlin.Suppress
import kotlin.collections.List

/**
 * Ephemeral Disk Pool Properties
 * @property disks Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
 * @property replicas The number of data copies. Default 3.
 */
public data class EphemeralDiskResponse(
    public val disks: List<DiskResponse>? = null,
    public val replicas: Double? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerstorage.outputs.EphemeralDiskResponse):
            EphemeralDiskResponse = EphemeralDiskResponse(
            disks = javaType.disks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerstorage.kotlin.outputs.DiskResponse.Companion.toKotlin(args0)
                })
            }),
            replicas = javaType.replicas().map({ args0 -> args0 }).orElse(null),
        )
    }
}
