@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin

import com.pulumi.azurenative.costmanagement.CostmanagementFunctions.getBudgetPlain
import com.pulumi.azurenative.costmanagement.CostmanagementFunctions.getCloudConnectorPlain
import com.pulumi.azurenative.costmanagement.CostmanagementFunctions.getConnectorPlain
import com.pulumi.azurenative.costmanagement.CostmanagementFunctions.getCostAllocationRulePlain
import com.pulumi.azurenative.costmanagement.CostmanagementFunctions.getExportPlain
import com.pulumi.azurenative.costmanagement.CostmanagementFunctions.getMarkupRulePlain
import com.pulumi.azurenative.costmanagement.CostmanagementFunctions.getReportByBillingAccountPlain
import com.pulumi.azurenative.costmanagement.CostmanagementFunctions.getReportByDepartmentPlain
import com.pulumi.azurenative.costmanagement.CostmanagementFunctions.getReportByResourceGroupNamePlain
import com.pulumi.azurenative.costmanagement.CostmanagementFunctions.getReportPlain
import com.pulumi.azurenative.costmanagement.CostmanagementFunctions.getScheduledActionByScopePlain
import com.pulumi.azurenative.costmanagement.CostmanagementFunctions.getScheduledActionPlain
import com.pulumi.azurenative.costmanagement.CostmanagementFunctions.getSettingPlain
import com.pulumi.azurenative.costmanagement.CostmanagementFunctions.getTagInheritanceSettingPlain
import com.pulumi.azurenative.costmanagement.CostmanagementFunctions.getViewByScopePlain
import com.pulumi.azurenative.costmanagement.CostmanagementFunctions.getViewPlain
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetBudgetPlainArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetBudgetPlainArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetCloudConnectorPlainArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetCloudConnectorPlainArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetConnectorPlainArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetConnectorPlainArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetCostAllocationRulePlainArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetCostAllocationRulePlainArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetExportPlainArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetExportPlainArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetMarkupRulePlainArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetMarkupRulePlainArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetReportByBillingAccountPlainArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetReportByBillingAccountPlainArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetReportByDepartmentPlainArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetReportByDepartmentPlainArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetReportByResourceGroupNamePlainArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetReportByResourceGroupNamePlainArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetReportPlainArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetReportPlainArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetScheduledActionByScopePlainArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetScheduledActionByScopePlainArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetScheduledActionPlainArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetScheduledActionPlainArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetSettingPlainArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetSettingPlainArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetTagInheritanceSettingPlainArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetTagInheritanceSettingPlainArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetViewByScopePlainArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetViewByScopePlainArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetViewPlainArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.GetViewPlainArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetBudgetResult
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetCloudConnectorResult
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetConnectorResult
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetCostAllocationRuleResult
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetExportResult
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetMarkupRuleResult
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetReportByBillingAccountResult
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetReportByDepartmentResult
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetReportByResourceGroupNameResult
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetReportResult
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetScheduledActionByScopeResult
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetScheduledActionResult
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetSettingResult
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetTagInheritanceSettingResult
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetViewByScopeResult
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetViewResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetBudgetResult.Companion.toKotlin as getBudgetResultToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetCloudConnectorResult.Companion.toKotlin as getCloudConnectorResultToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetConnectorResult.Companion.toKotlin as getConnectorResultToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetCostAllocationRuleResult.Companion.toKotlin as getCostAllocationRuleResultToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetExportResult.Companion.toKotlin as getExportResultToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetMarkupRuleResult.Companion.toKotlin as getMarkupRuleResultToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetReportByBillingAccountResult.Companion.toKotlin as getReportByBillingAccountResultToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetReportByDepartmentResult.Companion.toKotlin as getReportByDepartmentResultToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetReportByResourceGroupNameResult.Companion.toKotlin as getReportByResourceGroupNameResultToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetReportResult.Companion.toKotlin as getReportResultToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetScheduledActionByScopeResult.Companion.toKotlin as getScheduledActionByScopeResultToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetScheduledActionResult.Companion.toKotlin as getScheduledActionResultToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetSettingResult.Companion.toKotlin as getSettingResultToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetTagInheritanceSettingResult.Companion.toKotlin as getTagInheritanceSettingResultToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetViewByScopeResult.Companion.toKotlin as getViewByScopeResultToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.GetViewResult.Companion.toKotlin as getViewResultToKotlin

public object CostmanagementFunctions {
    /**
     * Gets the budget for the scope by budget name.
     * Azure REST API version: 2023-04-01-preview.
     * Other available API versions: 2019-04-01-preview, 2023-08-01, 2023-09-01, 2023-11-01.
     * @param argument null
     * @return A budget resource.
     */
    public suspend fun getBudget(argument: GetBudgetPlainArgs): GetBudgetResult =
        getBudgetResultToKotlin(getBudgetPlain(argument.toJava()).await())

    /**
     * @see [getBudget].
     * @param budgetName Budget Name.
     * @param scope The scope associated with budget operations.
     *  Supported scopes for **CategoryType: Cost**
     *  Azure RBAC Scopes:
     * - '/subscriptions/{subscriptionId}/' for subscription scope
     * - '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope
     * - '/providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management Group scope
     *  EA (Enterprise Agreement) Scopes:
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope
     *  MCA (Modern Customer Agreement) Scopes:
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billingProfile scope
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}' for invoiceSection scope
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' for customer scope (CSP only)
     *  Supported scopes for **CategoryType: ReservationUtilization**
     *  EA (Enterprise Agreement) Scopes:
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account Scope
     * MCA (Modern Customer Agreement) Scopes:
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billingProfile scope (non-CSP only)
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' for customer scope (CSP only)
     * @return A budget resource.
     */
    public suspend fun getBudget(budgetName: String, scope: String): GetBudgetResult {
        val argument = GetBudgetPlainArgs(
            budgetName = budgetName,
            scope = scope,
        )
        return getBudgetResultToKotlin(getBudgetPlain(argument.toJava()).await())
    }

    /**
     * @see [getBudget].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;costmanagement&#46;kotlin&#46;inputs&#46;GetBudgetPlainArgs].
     * @return A budget resource.
     */
    public suspend fun getBudget(argument: suspend GetBudgetPlainArgsBuilder.() -> Unit):
        GetBudgetResult {
        val builder = GetBudgetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBudgetResultToKotlin(getBudgetPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a cloud connector definition
     * Azure REST API version: 2019-03-01-preview.
     * @param argument null
     * @return The Connector model definition
     */
    public suspend fun getCloudConnector(argument: GetCloudConnectorPlainArgs):
        GetCloudConnectorResult =
        getCloudConnectorResultToKotlin(getCloudConnectorPlain(argument.toJava()).await())

    /**
     * @see [getCloudConnector].
     * @param connectorName Connector Name.
     * @param expand May be used to expand the collectionInfo property. By default, collectionInfo is not included.
     * @return The Connector model definition
     */
    public suspend fun getCloudConnector(connectorName: String, expand: String? = null):
        GetCloudConnectorResult {
        val argument = GetCloudConnectorPlainArgs(
            connectorName = connectorName,
            expand = expand,
        )
        return getCloudConnectorResultToKotlin(getCloudConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getCloudConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;costmanagement&#46;kotlin&#46;inputs&#46;GetCloudConnectorPlainArgs].
     * @return The Connector model definition
     */
    public suspend
    fun getCloudConnector(argument: suspend GetCloudConnectorPlainArgsBuilder.() -> Unit):
        GetCloudConnectorResult {
        val builder = GetCloudConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCloudConnectorResultToKotlin(getCloudConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a connector definition
     * Azure REST API version: 2018-08-01-preview.
     * @param argument null
     * @return The Connector model definition
     */
    public suspend fun getConnector(argument: GetConnectorPlainArgs): GetConnectorResult =
        getConnectorResultToKotlin(getConnectorPlain(argument.toJava()).await())

    /**
     * @see [getConnector].
     * @param connectorName Connector Name.
     * @param resourceGroupName Azure Resource Group Name.
     * @return The Connector model definition
     */
    public suspend fun getConnector(connectorName: String, resourceGroupName: String):
        GetConnectorResult {
        val argument = GetConnectorPlainArgs(
            connectorName = connectorName,
            resourceGroupName = resourceGroupName,
        )
        return getConnectorResultToKotlin(getConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;costmanagement&#46;kotlin&#46;inputs&#46;GetConnectorPlainArgs].
     * @return The Connector model definition
     */
    public suspend fun getConnector(argument: suspend GetConnectorPlainArgsBuilder.() -> Unit):
        GetConnectorResult {
        val builder = GetConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectorResultToKotlin(getConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a cost allocation rule by rule name and billing account or enterprise enrollment.
     * Azure REST API version: 2020-03-01-preview.
     * Other available API versions: 2023-08-01, 2023-09-01, 2023-11-01.
     * @param argument null
     * @return The cost allocation rule model definition
     */
    public suspend fun getCostAllocationRule(argument: GetCostAllocationRulePlainArgs):
        GetCostAllocationRuleResult =
        getCostAllocationRuleResultToKotlin(getCostAllocationRulePlain(argument.toJava()).await())

    /**
     * @see [getCostAllocationRule].
     * @param billingAccountId BillingAccount ID
     * @param ruleName Cost allocation rule name. The name cannot include spaces or any non alphanumeric characters other than '_' and '-'. The max length is 260 characters.
     * @return The cost allocation rule model definition
     */
    public suspend fun getCostAllocationRule(billingAccountId: String, ruleName: String):
        GetCostAllocationRuleResult {
        val argument = GetCostAllocationRulePlainArgs(
            billingAccountId = billingAccountId,
            ruleName = ruleName,
        )
        return getCostAllocationRuleResultToKotlin(getCostAllocationRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getCostAllocationRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;costmanagement&#46;kotlin&#46;inputs&#46;GetCostAllocationRulePlainArgs].
     * @return The cost allocation rule model definition
     */
    public suspend
    fun getCostAllocationRule(argument: suspend GetCostAllocationRulePlainArgsBuilder.() -> Unit):
        GetCostAllocationRuleResult {
        val builder = GetCostAllocationRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCostAllocationRuleResultToKotlin(getCostAllocationRulePlain(builtArgument.toJava()).await())
    }

    /**
     * The operation to get the export for the defined scope by export name.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2019-10-01, 2023-04-01-preview, 2023-08-01, 2023-09-01, 2023-11-01.
     * @param argument null
     * @return An export resource.
     */
    public suspend fun getExport(argument: GetExportPlainArgs): GetExportResult =
        getExportResultToKotlin(getExportPlain(argument.toJava()).await())

    /**
     * @see [getExport].
     * @param expand May be used to expand the properties within an export. Currently only 'runHistory' is supported and will return information for the last 10 runs of the export.
     * @param exportName Export Name.
     * @param scope The scope associated with export operations. This includes '/subscriptions/{subscriptionId}/' for subscription scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope and '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, '/providers/Microsoft.Management/managementGroups/{managementGroupId} for Management Group scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billingProfile scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}' for invoiceSection scope, and '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' specific for partners.
     * @return An export resource.
     */
    public suspend fun getExport(
        expand: String? = null,
        exportName: String,
        scope: String,
    ): GetExportResult {
        val argument = GetExportPlainArgs(
            expand = expand,
            exportName = exportName,
            scope = scope,
        )
        return getExportResultToKotlin(getExportPlain(argument.toJava()).await())
    }

    /**
     * @see [getExport].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;costmanagement&#46;kotlin&#46;inputs&#46;GetExportPlainArgs].
     * @return An export resource.
     */
    public suspend fun getExport(argument: suspend GetExportPlainArgsBuilder.() -> Unit):
        GetExportResult {
        val builder = GetExportPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getExportResultToKotlin(getExportPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a markup rule by its rule name.
     * Azure REST API version: 2022-10-05-preview.
     * @param argument null
     * @return Markup rule
     */
    public suspend fun getMarkupRule(argument: GetMarkupRulePlainArgs): GetMarkupRuleResult =
        getMarkupRuleResultToKotlin(getMarkupRulePlain(argument.toJava()).await())

    /**
     * @see [getMarkupRule].
     * @param billingAccountId BillingAccount ID
     * @param billingProfileId BillingProfile ID
     * @param name Markup rule name.
     * @return Markup rule
     */
    public suspend fun getMarkupRule(
        billingAccountId: String,
        billingProfileId: String,
        name: String,
    ): GetMarkupRuleResult {
        val argument = GetMarkupRulePlainArgs(
            billingAccountId = billingAccountId,
            billingProfileId = billingProfileId,
            name = name,
        )
        return getMarkupRuleResultToKotlin(getMarkupRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getMarkupRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;costmanagement&#46;kotlin&#46;inputs&#46;GetMarkupRulePlainArgs].
     * @return Markup rule
     */
    public suspend fun getMarkupRule(argument: suspend GetMarkupRulePlainArgsBuilder.() -> Unit):
        GetMarkupRuleResult {
        val builder = GetMarkupRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMarkupRuleResultToKotlin(getMarkupRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the report for a subscription by report name.
     * Azure REST API version: 2018-08-01-preview.
     * @param argument null
     * @return A report resource.
     */
    public suspend fun getReport(argument: GetReportPlainArgs): GetReportResult =
        getReportResultToKotlin(getReportPlain(argument.toJava()).await())

    /**
     * @see [getReport].
     * @param reportName Report Name.
     * @return A report resource.
     */
    public suspend fun getReport(reportName: String): GetReportResult {
        val argument = GetReportPlainArgs(
            reportName = reportName,
        )
        return getReportResultToKotlin(getReportPlain(argument.toJava()).await())
    }

    /**
     * @see [getReport].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;costmanagement&#46;kotlin&#46;inputs&#46;GetReportPlainArgs].
     * @return A report resource.
     */
    public suspend fun getReport(argument: suspend GetReportPlainArgsBuilder.() -> Unit):
        GetReportResult {
        val builder = GetReportPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReportResultToKotlin(getReportPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the report for a billing account by report name.
     * Azure REST API version: 2018-08-01-preview.
     * @param argument null
     * @return A report resource.
     */
    public suspend fun getReportByBillingAccount(argument: GetReportByBillingAccountPlainArgs):
        GetReportByBillingAccountResult =
        getReportByBillingAccountResultToKotlin(getReportByBillingAccountPlain(argument.toJava()).await())

    /**
     * @see [getReportByBillingAccount].
     * @param billingAccountId BillingAccount ID
     * @param reportName Report Name.
     * @return A report resource.
     */
    public suspend fun getReportByBillingAccount(billingAccountId: String, reportName: String):
        GetReportByBillingAccountResult {
        val argument = GetReportByBillingAccountPlainArgs(
            billingAccountId = billingAccountId,
            reportName = reportName,
        )
        return getReportByBillingAccountResultToKotlin(getReportByBillingAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getReportByBillingAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;costmanagement&#46;kotlin&#46;inputs&#46;GetReportByBillingAccountPlainArgs].
     * @return A report resource.
     */
    public suspend
    fun getReportByBillingAccount(argument: suspend GetReportByBillingAccountPlainArgsBuilder.() -> Unit):
        GetReportByBillingAccountResult {
        val builder = GetReportByBillingAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReportByBillingAccountResultToKotlin(getReportByBillingAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the report for a department by report name.
     * Azure REST API version: 2018-08-01-preview.
     * @param argument null
     * @return A report resource.
     */
    public suspend fun getReportByDepartment(argument: GetReportByDepartmentPlainArgs):
        GetReportByDepartmentResult =
        getReportByDepartmentResultToKotlin(getReportByDepartmentPlain(argument.toJava()).await())

    /**
     * @see [getReportByDepartment].
     * @param departmentId Department ID
     * @param reportName Report Name.
     * @return A report resource.
     */
    public suspend fun getReportByDepartment(departmentId: String, reportName: String):
        GetReportByDepartmentResult {
        val argument = GetReportByDepartmentPlainArgs(
            departmentId = departmentId,
            reportName = reportName,
        )
        return getReportByDepartmentResultToKotlin(getReportByDepartmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getReportByDepartment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;costmanagement&#46;kotlin&#46;inputs&#46;GetReportByDepartmentPlainArgs].
     * @return A report resource.
     */
    public suspend
    fun getReportByDepartment(argument: suspend GetReportByDepartmentPlainArgsBuilder.() -> Unit):
        GetReportByDepartmentResult {
        val builder = GetReportByDepartmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReportByDepartmentResultToKotlin(getReportByDepartmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the report for a resource group under a subscription by report name.
     * Azure REST API version: 2018-08-01-preview.
     * @param argument null
     * @return A report resource.
     */
    public suspend fun getReportByResourceGroupName(argument: GetReportByResourceGroupNamePlainArgs):
        GetReportByResourceGroupNameResult =
        getReportByResourceGroupNameResultToKotlin(getReportByResourceGroupNamePlain(argument.toJava()).await())

    /**
     * @see [getReportByResourceGroupName].
     * @param reportName Report Name.
     * @param resourceGroupName Azure Resource Group Name.
     * @return A report resource.
     */
    public suspend fun getReportByResourceGroupName(reportName: String, resourceGroupName: String):
        GetReportByResourceGroupNameResult {
        val argument = GetReportByResourceGroupNamePlainArgs(
            reportName = reportName,
            resourceGroupName = resourceGroupName,
        )
        return getReportByResourceGroupNameResultToKotlin(getReportByResourceGroupNamePlain(argument.toJava()).await())
    }

    /**
     * @see [getReportByResourceGroupName].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;costmanagement&#46;kotlin&#46;inputs&#46;GetReportByResourceGroupNamePlainArgs].
     * @return A report resource.
     */
    public suspend
    fun getReportByResourceGroupName(argument: suspend GetReportByResourceGroupNamePlainArgsBuilder.() -> Unit):
        GetReportByResourceGroupNameResult {
        val builder = GetReportByResourceGroupNamePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReportByResourceGroupNameResultToKotlin(getReportByResourceGroupNamePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the private scheduled action by name.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2023-04-01-preview, 2023-08-01, 2023-09-01, 2023-11-01.
     * @param argument null
     * @return Scheduled action definition.
     */
    public suspend fun getScheduledAction(argument: GetScheduledActionPlainArgs):
        GetScheduledActionResult =
        getScheduledActionResultToKotlin(getScheduledActionPlain(argument.toJava()).await())

    /**
     * @see [getScheduledAction].
     * @param name Scheduled action name.
     * @return Scheduled action definition.
     */
    public suspend fun getScheduledAction(name: String): GetScheduledActionResult {
        val argument = GetScheduledActionPlainArgs(
            name = name,
        )
        return getScheduledActionResultToKotlin(getScheduledActionPlain(argument.toJava()).await())
    }

    /**
     * @see [getScheduledAction].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;costmanagement&#46;kotlin&#46;inputs&#46;GetScheduledActionPlainArgs].
     * @return Scheduled action definition.
     */
    public suspend
    fun getScheduledAction(argument: suspend GetScheduledActionPlainArgsBuilder.() -> Unit):
        GetScheduledActionResult {
        val builder = GetScheduledActionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScheduledActionResultToKotlin(getScheduledActionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the shared scheduled action from the given scope by name.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2023-04-01-preview, 2023-08-01, 2023-09-01, 2023-11-01.
     * @param argument null
     * @return Scheduled action definition.
     */
    public suspend fun getScheduledActionByScope(argument: GetScheduledActionByScopePlainArgs):
        GetScheduledActionByScopeResult =
        getScheduledActionByScopeResultToKotlin(getScheduledActionByScopePlain(argument.toJava()).await())

    /**
     * @see [getScheduledActionByScope].
     * @param name Scheduled action name.
     * @param scope The scope associated with scheduled action operations. This includes 'subscriptions/{subscriptionId}' for subscription scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection scope, 'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for External Billing Account scope and 'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for External Subscription scope. Note: Insight Alerts are only available on subscription scope.
     * @return Scheduled action definition.
     */
    public suspend fun getScheduledActionByScope(name: String, scope: String):
        GetScheduledActionByScopeResult {
        val argument = GetScheduledActionByScopePlainArgs(
            name = name,
            scope = scope,
        )
        return getScheduledActionByScopeResultToKotlin(getScheduledActionByScopePlain(argument.toJava()).await())
    }

    /**
     * @see [getScheduledActionByScope].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;costmanagement&#46;kotlin&#46;inputs&#46;GetScheduledActionByScopePlainArgs].
     * @return Scheduled action definition.
     */
    public suspend
    fun getScheduledActionByScope(argument: suspend GetScheduledActionByScopePlainArgsBuilder.() -> Unit):
        GetScheduledActionByScopeResult {
        val builder = GetScheduledActionByScopePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScheduledActionByScopeResultToKotlin(getScheduledActionByScopePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves the current value for a specific setting.
     * Azure REST API version: 2019-11-01.
     * @param argument null
     * @return State of the myscope setting.
     */
    public suspend fun getSetting(argument: GetSettingPlainArgs): GetSettingResult =
        getSettingResultToKotlin(getSettingPlain(argument.toJava()).await())

    /**
     * @see [getSetting].
     * @param settingName Name of the setting. Allowed values: myscope
     * @return State of the myscope setting.
     */
    public suspend fun getSetting(settingName: String): GetSettingResult {
        val argument = GetSettingPlainArgs(
            settingName = settingName,
        )
        return getSettingResultToKotlin(getSettingPlain(argument.toJava()).await())
    }

    /**
     * @see [getSetting].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;costmanagement&#46;kotlin&#46;inputs&#46;GetSettingPlainArgs].
     * @return State of the myscope setting.
     */
    public suspend fun getSetting(argument: suspend GetSettingPlainArgsBuilder.() -> Unit):
        GetSettingResult {
        val builder = GetSettingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSettingResultToKotlin(getSettingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the setting from the given scope by name.
     * Azure REST API version: 2022-10-05-preview.
     * @param argument null
     * @return Tag Inheritance Setting definition.
     */
    public suspend fun getTagInheritanceSetting(argument: GetTagInheritanceSettingPlainArgs):
        GetTagInheritanceSettingResult =
        getTagInheritanceSettingResultToKotlin(getTagInheritanceSettingPlain(argument.toJava()).await())

    /**
     * @see [getTagInheritanceSetting].
     * @param scope The scope associated with this setting. This includes 'subscriptions/{subscriptionId}' for subscription scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billing profile scope.
     * @param type Setting type.
     * @return Tag Inheritance Setting definition.
     */
    public suspend fun getTagInheritanceSetting(scope: String, type: String):
        GetTagInheritanceSettingResult {
        val argument = GetTagInheritanceSettingPlainArgs(
            scope = scope,
            type = type,
        )
        return getTagInheritanceSettingResultToKotlin(getTagInheritanceSettingPlain(argument.toJava()).await())
    }

    /**
     * @see [getTagInheritanceSetting].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;costmanagement&#46;kotlin&#46;inputs&#46;GetTagInheritanceSettingPlainArgs].
     * @return Tag Inheritance Setting definition.
     */
    public suspend
    fun getTagInheritanceSetting(argument: suspend GetTagInheritanceSettingPlainArgsBuilder.() -> Unit):
        GetTagInheritanceSettingResult {
        val builder = GetTagInheritanceSettingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTagInheritanceSettingResultToKotlin(getTagInheritanceSettingPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the view by view name.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2019-11-01, 2020-06-01, 2022-10-01, 2022-10-05-preview, 2023-04-01-preview, 2023-08-01, 2023-09-01, 2023-11-01.
     * @param argument null
     * @return States and configurations of Cost Analysis.
     */
    public suspend fun getView(argument: GetViewPlainArgs): GetViewResult =
        getViewResultToKotlin(getViewPlain(argument.toJava()).await())

    /**
     * @see [getView].
     * @param viewName View name
     * @return States and configurations of Cost Analysis.
     */
    public suspend fun getView(viewName: String): GetViewResult {
        val argument = GetViewPlainArgs(
            viewName = viewName,
        )
        return getViewResultToKotlin(getViewPlain(argument.toJava()).await())
    }

    /**
     * @see [getView].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;costmanagement&#46;kotlin&#46;inputs&#46;GetViewPlainArgs].
     * @return States and configurations of Cost Analysis.
     */
    public suspend fun getView(argument: suspend GetViewPlainArgsBuilder.() -> Unit): GetViewResult {
        val builder = GetViewPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getViewResultToKotlin(getViewPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the view for the defined scope by view name.
     * Azure REST API version: 2023-03-01.
     * Other available API versions: 2019-11-01, 2020-06-01, 2022-10-01, 2022-10-05-preview, 2023-04-01-preview, 2023-08-01, 2023-09-01, 2023-11-01.
     * @param argument null
     * @return States and configurations of Cost Analysis.
     */
    public suspend fun getViewByScope(argument: GetViewByScopePlainArgs): GetViewByScopeResult =
        getViewByScopeResultToKotlin(getViewByScopePlain(argument.toJava()).await())

    /**
     * @see [getViewByScope].
     * @param scope The scope associated with view operations. This includes 'subscriptions/{subscriptionId}' for subscription scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection scope, 'providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management Group scope, 'providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for External Billing Account scope and 'providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for External Subscription scope.
     * @param viewName View name
     * @return States and configurations of Cost Analysis.
     */
    public suspend fun getViewByScope(scope: String, viewName: String): GetViewByScopeResult {
        val argument = GetViewByScopePlainArgs(
            scope = scope,
            viewName = viewName,
        )
        return getViewByScopeResultToKotlin(getViewByScopePlain(argument.toJava()).await())
    }

    /**
     * @see [getViewByScope].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;costmanagement&#46;kotlin&#46;inputs&#46;GetViewByScopePlainArgs].
     * @return States and configurations of Cost Analysis.
     */
    public suspend fun getViewByScope(argument: suspend GetViewByScopePlainArgsBuilder.() -> Unit):
        GetViewByScopeResult {
        val builder = GetViewByScopePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getViewByScopeResultToKotlin(getViewByScopePlain(builtArgument.toJava()).await())
    }
}
