@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin

import com.pulumi.azurenative.costmanagement.ScheduledActionByScopeArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.ScheduledActionKind
import com.pulumi.azurenative.costmanagement.kotlin.enums.ScheduledActionStatus
import com.pulumi.azurenative.costmanagement.kotlin.inputs.FileDestinationArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.FileDestinationArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.NotificationPropertiesArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.NotificationPropertiesArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.SchedulePropertiesArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.SchedulePropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Scheduled action definition.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2023-04-01-preview, 2023-08-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### CreateOrUpdateInsightAlertScheduledActionByScope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scheduledActionByScope = new AzureNative.CostManagement.ScheduledActionByScope("scheduledActionByScope", new()
 *     {
 *         DisplayName = "Daily anomaly by resource",
 *         Kind = "InsightAlert",
 *         Name = "dailyAnomalyByResource",
 *         Notification = new AzureNative.CostManagement.Inputs.NotificationPropertiesArgs
 *         {
 *             Subject = "Cost anomaly detected in the resource",
 *             To = new[]
 *             {
 *                 "user@gmail.com",
 *                 "team@gmail.com",
 *             },
 *         },
 *         Schedule = new AzureNative.CostManagement.Inputs.SchedulePropertiesArgs
 *         {
 *             EndDate = "2021-06-19T22:21:51.1287144Z",
 *             Frequency = "Daily",
 *             StartDate = "2020-06-19T22:21:51.1287144Z",
 *         },
 *         Scope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *         Status = "Enabled",
 *         ViewId = "/providers/Microsoft.CostManagement/views/swaggerExample",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := costmanagement.NewScheduledActionByScope(ctx, "scheduledActionByScope", &costmanagement.ScheduledActionByScopeArgs{
 * 			DisplayName: pulumi.String("Daily anomaly by resource"),
 * 			Kind:        pulumi.String("InsightAlert"),
 * 			Name:        pulumi.String("dailyAnomalyByResource"),
 * 			Notification: &costmanagement.NotificationPropertiesArgs{
 * 				Subject: pulumi.String("Cost anomaly detected in the resource"),
 * 				To: pulumi.StringArray{
 * 					pulumi.String("user@gmail.com"),
 * 					pulumi.String("team@gmail.com"),
 * 				},
 * 			},
 * 			Schedule: &costmanagement.SchedulePropertiesArgs{
 * 				EndDate:   pulumi.String("2021-06-19T22:21:51.1287144Z"),
 * 				Frequency: pulumi.String("Daily"),
 * 				StartDate: pulumi.String("2020-06-19T22:21:51.1287144Z"),
 * 			},
 * 			Scope:  pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 			Status: pulumi.String("Enabled"),
 * 			ViewId: pulumi.String("/providers/Microsoft.CostManagement/views/swaggerExample"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.ScheduledActionByScope;
 * import com.pulumi.azurenative.costmanagement.ScheduledActionByScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scheduledActionByScope = new ScheduledActionByScope("scheduledActionByScope", ScheduledActionByScopeArgs.builder()
 *             .displayName("Daily anomaly by resource")
 *             .kind("InsightAlert")
 *             .name("dailyAnomalyByResource")
 *             .notification(Map.ofEntries(
 *                 Map.entry("subject", "Cost anomaly detected in the resource"),
 *                 Map.entry("to",
 *                     "user@gmail.com",
 *                     "team@gmail.com")
 *             ))
 *             .schedule(Map.ofEntries(
 *                 Map.entry("endDate", "2021-06-19T22:21:51.1287144Z"),
 *                 Map.entry("frequency", "Daily"),
 *                 Map.entry("startDate", "2020-06-19T22:21:51.1287144Z")
 *             ))
 *             .scope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .status("Enabled")
 *             .viewId("/providers/Microsoft.CostManagement/views/swaggerExample")
 *             .build());
 *     }
 * }
 * ```
 * ### CreateOrUpdateScheduledActionByScope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scheduledActionByScope = new AzureNative.CostManagement.ScheduledActionByScope("scheduledActionByScope", new()
 *     {
 *         DisplayName = "Monthly Cost By Resource",
 *         FileDestination = new AzureNative.CostManagement.Inputs.FileDestinationArgs
 *         {
 *             FileFormats = new[]
 *             {
 *                 "Csv",
 *             },
 *         },
 *         Kind = "Email",
 *         Name = "monthlyCostByResource",
 *         Notification = new AzureNative.CostManagement.Inputs.NotificationPropertiesArgs
 *         {
 *             Subject = "Cost by resource this month",
 *             To = new[]
 *             {
 *                 "user@gmail.com",
 *                 "team@gmail.com",
 *             },
 *         },
 *         Schedule = new AzureNative.CostManagement.Inputs.SchedulePropertiesArgs
 *         {
 *             DaysOfWeek = new[]
 *             {
 *                 "Monday",
 *             },
 *             EndDate = "2021-06-19T22:21:51.1287144Z",
 *             Frequency = "Monthly",
 *             HourOfDay = 10,
 *             StartDate = "2020-06-19T22:21:51.1287144Z",
 *             WeeksOfMonth = new[]
 *             {
 *                 "First",
 *                 "Third",
 *             },
 *         },
 *         Scope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *         Status = "Enabled",
 *         ViewId = "/providers/Microsoft.CostManagement/views/swaggerExample",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := costmanagement.NewScheduledActionByScope(ctx, "scheduledActionByScope", &costmanagement.ScheduledActionByScopeArgs{
 * 			DisplayName: pulumi.String("Monthly Cost By Resource"),
 * 			FileDestination: &costmanagement.FileDestinationArgs{
 * 				FileFormats: pulumi.StringArray{
 * 					pulumi.String("Csv"),
 * 				},
 * 			},
 * 			Kind: pulumi.String("Email"),
 * 			Name: pulumi.String("monthlyCostByResource"),
 * 			Notification: &costmanagement.NotificationPropertiesArgs{
 * 				Subject: pulumi.String("Cost by resource this month"),
 * 				To: pulumi.StringArray{
 * 					pulumi.String("user@gmail.com"),
 * 					pulumi.String("team@gmail.com"),
 * 				},
 * 			},
 * 			Schedule: &costmanagement.SchedulePropertiesArgs{
 * 				DaysOfWeek: pulumi.StringArray{
 * 					pulumi.String("Monday"),
 * 				},
 * 				EndDate:   pulumi.String("2021-06-19T22:21:51.1287144Z"),
 * 				Frequency: pulumi.String("Monthly"),
 * 				HourOfDay: pulumi.Int(10),
 * 				StartDate: pulumi.String("2020-06-19T22:21:51.1287144Z"),
 * 				WeeksOfMonth: pulumi.StringArray{
 * 					pulumi.String("First"),
 * 					pulumi.String("Third"),
 * 				},
 * 			},
 * 			Scope:  pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 			Status: pulumi.String("Enabled"),
 * 			ViewId: pulumi.String("/providers/Microsoft.CostManagement/views/swaggerExample"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.ScheduledActionByScope;
 * import com.pulumi.azurenative.costmanagement.ScheduledActionByScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scheduledActionByScope = new ScheduledActionByScope("scheduledActionByScope", ScheduledActionByScopeArgs.builder()
 *             .displayName("Monthly Cost By Resource")
 *             .fileDestination(Map.of("fileFormats", "Csv"))
 *             .kind("Email")
 *             .name("monthlyCostByResource")
 *             .notification(Map.ofEntries(
 *                 Map.entry("subject", "Cost by resource this month"),
 *                 Map.entry("to",
 *                     "user@gmail.com",
 *                     "team@gmail.com")
 *             ))
 *             .schedule(Map.ofEntries(
 *                 Map.entry("daysOfWeek", "Monday"),
 *                 Map.entry("endDate", "2021-06-19T22:21:51.1287144Z"),
 *                 Map.entry("frequency", "Monthly"),
 *                 Map.entry("hourOfDay", 10),
 *                 Map.entry("startDate", "2020-06-19T22:21:51.1287144Z"),
 *                 Map.entry("weeksOfMonth",
 *                     "First",
 *                     "Third")
 *             ))
 *             .scope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .status("Enabled")
 *             .viewId("/providers/Microsoft.CostManagement/views/swaggerExample")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:costmanagement:ScheduledActionByScope monthlyCostByResource /{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}
 * ```
 * @property displayName Scheduled action name.
 * @property fileDestination Destination format of the view data. This is optional.
 * @property kind Kind of the scheduled action.
 * @property name Scheduled action name.
 * @property notification Notification properties based on scheduled action kind.
 * @property notificationEmail Email address of the point of contact that should get the unsubscribe requests and notification emails.
 * @property schedule Schedule of the scheduled action.
 * @property scope For private scheduled action(Create or Update), scope will be empty.<br /> For shared scheduled action(Create or Update By Scope), Cost Management scope can be 'subscriptions/{subscriptionId}' for subscription scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection scope, '/providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for ExternalBillingAccount scope, and '/providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for ExternalSubscription scope.
 * @property status Status of the scheduled action.
 * @property viewId Cost analysis viewId used for scheduled action. For example, '/providers/Microsoft.CostManagement/views/swaggerExample'
 */
public data class ScheduledActionByScopeArgs(
    public val displayName: Output<String>? = null,
    public val fileDestination: Output<FileDestinationArgs>? = null,
    public val kind: Output<Either<String, ScheduledActionKind>>? = null,
    public val name: Output<String>? = null,
    public val notification: Output<NotificationPropertiesArgs>? = null,
    public val notificationEmail: Output<String>? = null,
    public val schedule: Output<SchedulePropertiesArgs>? = null,
    public val scope: Output<String>? = null,
    public val status: Output<Either<String, ScheduledActionStatus>>? = null,
    public val viewId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.ScheduledActionByScopeArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.ScheduledActionByScopeArgs =
        com.pulumi.azurenative.costmanagement.ScheduledActionByScopeArgs.builder()
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .fileDestination(fileDestination?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .notification(notification?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .notificationEmail(notificationEmail?.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .viewId(viewId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduledActionByScopeArgs].
 */
@PulumiTagMarker
public class ScheduledActionByScopeArgsBuilder internal constructor() {
    private var displayName: Output<String>? = null

    private var fileDestination: Output<FileDestinationArgs>? = null

    private var kind: Output<Either<String, ScheduledActionKind>>? = null

    private var name: Output<String>? = null

    private var notification: Output<NotificationPropertiesArgs>? = null

    private var notificationEmail: Output<String>? = null

    private var schedule: Output<SchedulePropertiesArgs>? = null

    private var scope: Output<String>? = null

    private var status: Output<Either<String, ScheduledActionStatus>>? = null

    private var viewId: Output<String>? = null

    /**
     * @param value Scheduled action name.
     */
    @JvmName("efxyxwjncrjpgyyc")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Destination format of the view data. This is optional.
     */
    @JvmName("fwwvkqcwrgnutvxy")
    public suspend fun fileDestination(`value`: Output<FileDestinationArgs>) {
        this.fileDestination = value
    }

    /**
     * @param value Kind of the scheduled action.
     */
    @JvmName("cyiqaminllqttwsb")
    public suspend fun kind(`value`: Output<Either<String, ScheduledActionKind>>) {
        this.kind = value
    }

    /**
     * @param value Scheduled action name.
     */
    @JvmName("hypmdsahqhfrfpgj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Notification properties based on scheduled action kind.
     */
    @JvmName("lwhdcbyotxepmwea")
    public suspend fun notification(`value`: Output<NotificationPropertiesArgs>) {
        this.notification = value
    }

    /**
     * @param value Email address of the point of contact that should get the unsubscribe requests and notification emails.
     */
    @JvmName("liksnidtfjqdayec")
    public suspend fun notificationEmail(`value`: Output<String>) {
        this.notificationEmail = value
    }

    /**
     * @param value Schedule of the scheduled action.
     */
    @JvmName("osaikbrsxnhrnjvf")
    public suspend fun schedule(`value`: Output<SchedulePropertiesArgs>) {
        this.schedule = value
    }

    /**
     * @param value For private scheduled action(Create or Update), scope will be empty.<br /> For shared scheduled action(Create or Update By Scope), Cost Management scope can be 'subscriptions/{subscriptionId}' for subscription scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection scope, '/providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for ExternalBillingAccount scope, and '/providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for ExternalSubscription scope.
     */
    @JvmName("vhulobthdwpcyonv")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value Status of the scheduled action.
     */
    @JvmName("tyluysvjiewybgot")
    public suspend fun status(`value`: Output<Either<String, ScheduledActionStatus>>) {
        this.status = value
    }

    /**
     * @param value Cost analysis viewId used for scheduled action. For example, '/providers/Microsoft.CostManagement/views/swaggerExample'
     */
    @JvmName("pjmshuclsllsckid")
    public suspend fun viewId(`value`: Output<String>) {
        this.viewId = value
    }

    /**
     * @param value Scheduled action name.
     */
    @JvmName("crerxqjqfekwtxql")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Destination format of the view data. This is optional.
     */
    @JvmName("muokywjauclpdbju")
    public suspend fun fileDestination(`value`: FileDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileDestination = mapped
    }

    /**
     * @param argument Destination format of the view data. This is optional.
     */
    @JvmName("gsfrbaxyltfesjqu")
    public suspend fun fileDestination(argument: suspend FileDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = FileDestinationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.fileDestination = mapped
    }

    /**
     * @param value Kind of the scheduled action.
     */
    @JvmName("vbcjoqxrovnsxxtr")
    public suspend fun kind(`value`: Either<String, ScheduledActionKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Kind of the scheduled action.
     */
    @JvmName("jrvadjibljhwrttc")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScheduledActionKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Kind of the scheduled action.
     */
    @JvmName("gxgwdiujhrnyjlta")
    public fun kind(`value`: ScheduledActionKind) {
        val toBeMapped = Either.ofRight<String, ScheduledActionKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Scheduled action name.
     */
    @JvmName("pwliuvhvjxhxogiq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Notification properties based on scheduled action kind.
     */
    @JvmName("gllutqmptkmqtilx")
    public suspend fun notification(`value`: NotificationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notification = mapped
    }

    /**
     * @param argument Notification properties based on scheduled action kind.
     */
    @JvmName("ahqaefqlgasuqech")
    public suspend fun notification(argument: suspend NotificationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = NotificationPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.notification = mapped
    }

    /**
     * @param value Email address of the point of contact that should get the unsubscribe requests and notification emails.
     */
    @JvmName("xmmsyqwmgbnhwbpw")
    public suspend fun notificationEmail(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationEmail = mapped
    }

    /**
     * @param value Schedule of the scheduled action.
     */
    @JvmName("kgaafelkfadojhlf")
    public suspend fun schedule(`value`: SchedulePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument Schedule of the scheduled action.
     */
    @JvmName("hfawidkduqtbquvx")
    public suspend fun schedule(argument: suspend SchedulePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SchedulePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    /**
     * @param value For private scheduled action(Create or Update), scope will be empty.<br /> For shared scheduled action(Create or Update By Scope), Cost Management scope can be 'subscriptions/{subscriptionId}' for subscription scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection scope, '/providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for ExternalBillingAccount scope, and '/providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for ExternalSubscription scope.
     */
    @JvmName("fjskvtjycfbxtipb")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Status of the scheduled action.
     */
    @JvmName("wtpyuhnuuqabjasu")
    public suspend fun status(`value`: Either<String, ScheduledActionStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Status of the scheduled action.
     */
    @JvmName("vlnruimalqdujein")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScheduledActionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Status of the scheduled action.
     */
    @JvmName("abbbhhghkeammjew")
    public fun status(`value`: ScheduledActionStatus) {
        val toBeMapped = Either.ofRight<String, ScheduledActionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Cost analysis viewId used for scheduled action. For example, '/providers/Microsoft.CostManagement/views/swaggerExample'
     */
    @JvmName("ibngsylhnnaekfpv")
    public suspend fun viewId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.viewId = mapped
    }

    internal fun build(): ScheduledActionByScopeArgs = ScheduledActionByScopeArgs(
        displayName = displayName,
        fileDestination = fileDestination,
        kind = kind,
        name = name,
        notification = notification,
        notificationEmail = notificationEmail,
        schedule = schedule,
        scope = scope,
        status = status,
        viewId = viewId,
    )
}
