@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin

import com.pulumi.azurenative.costmanagement.SettingArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.SettingsPropertiesCacheArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.SettingsPropertiesCacheArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * State of the myscope setting.
 * Azure REST API version: 2019-11-01. Prior API version in Azure Native 1.x: 2019-11-01.
 * ## Example Usage
 * ### CreateOrUpdateSetting
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var setting = new AzureNative.CostManagement.Setting("setting", new()
 *     {
 *         Cache = new[]
 *         {
 *             new AzureNative.CostManagement.Inputs.SettingsPropertiesCacheArgs
 *             {
 *                 Channel = "Modern",
 *                 Id = "/providers/Microsoft.Management/managementGroups/72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                 Name = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                 Parent = "/providers/Microsoft.Management/managementGroups/acm",
 *                 Status = "enabled",
 *                 Subchannel = "NotApplicable",
 *             },
 *         },
 *         Scope = "/subscriptions/00000000-0000-0000-0000-000000000000",
 *         SettingName = "myscope",
 *         StartOn = "LastUsed",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := costmanagement.NewSetting(ctx, "setting", &costmanagement.SettingArgs{
 * 			Cache: []costmanagement.SettingsPropertiesCacheArgs{
 * 				{
 * 					Channel:    pulumi.String("Modern"),
 * 					Id:         pulumi.String("/providers/Microsoft.Management/managementGroups/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 					Name:       pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 					Parent:     pulumi.String("/providers/Microsoft.Management/managementGroups/acm"),
 * 					Status:     pulumi.String("enabled"),
 * 					Subchannel: pulumi.String("NotApplicable"),
 * 				},
 * 			},
 * 			Scope:       pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000"),
 * 			SettingName: pulumi.String("myscope"),
 * 			StartOn:     pulumi.String("LastUsed"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.Setting;
 * import com.pulumi.azurenative.costmanagement.SettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var setting = new Setting("setting", SettingArgs.builder()
 *             .cache(Map.ofEntries(
 *                 Map.entry("channel", "Modern"),
 *                 Map.entry("id", "/providers/Microsoft.Management/managementGroups/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 *                 Map.entry("name", "72f988bf-86f1-41af-91ab-2d7cd011db47"),
 *                 Map.entry("parent", "/providers/Microsoft.Management/managementGroups/acm"),
 *                 Map.entry("status", "enabled"),
 *                 Map.entry("subchannel", "NotApplicable")
 *             ))
 *             .scope("/subscriptions/00000000-0000-0000-0000-000000000000")
 *             .settingName("myscope")
 *             .startOn("LastUsed")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:costmanagement:Setting myscope /providers/Microsoft.CostManagement/settings/{settingName}
 * ```
 * @property cache Array of scopes with additional details used by Cost Management in the Azure portal.
 * @property scope Sets the default scope the current user will see when they sign into Azure Cost Management in the Azure portal.
 * @property settingName Name of the setting. Allowed values: myscope
 * @property startOn Indicates what scope Cost Management in the Azure portal should default to. Allowed values: LastUsed.
 */
public data class SettingArgs(
    public val cache: Output<List<SettingsPropertiesCacheArgs>>? = null,
    public val scope: Output<String>? = null,
    public val settingName: Output<String>? = null,
    public val startOn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.SettingArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.SettingArgs =
        com.pulumi.azurenative.costmanagement.SettingArgs.builder()
            .cache(cache?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .settingName(settingName?.applyValue({ args0 -> args0 }))
            .startOn(startOn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SettingArgs].
 */
@PulumiTagMarker
public class SettingArgsBuilder internal constructor() {
    private var cache: Output<List<SettingsPropertiesCacheArgs>>? = null

    private var scope: Output<String>? = null

    private var settingName: Output<String>? = null

    private var startOn: Output<String>? = null

    /**
     * @param value Array of scopes with additional details used by Cost Management in the Azure portal.
     */
    @JvmName("fovkvuvxfjidbart")
    public suspend fun cache(`value`: Output<List<SettingsPropertiesCacheArgs>>) {
        this.cache = value
    }

    @JvmName("bbnwdposwuufnjlh")
    public suspend fun cache(vararg values: Output<SettingsPropertiesCacheArgs>) {
        this.cache = Output.all(values.asList())
    }

    /**
     * @param values Array of scopes with additional details used by Cost Management in the Azure portal.
     */
    @JvmName("hhvqwsmsftkilurm")
    public suspend fun cache(values: List<Output<SettingsPropertiesCacheArgs>>) {
        this.cache = Output.all(values)
    }

    /**
     * @param value Sets the default scope the current user will see when they sign into Azure Cost Management in the Azure portal.
     */
    @JvmName("usuaaucndwisrfym")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value Name of the setting. Allowed values: myscope
     */
    @JvmName("jupmonrrhekywbka")
    public suspend fun settingName(`value`: Output<String>) {
        this.settingName = value
    }

    /**
     * @param value Indicates what scope Cost Management in the Azure portal should default to. Allowed values: LastUsed.
     */
    @JvmName("wmfhfvqcvkpmvuuq")
    public suspend fun startOn(`value`: Output<String>) {
        this.startOn = value
    }

    /**
     * @param value Array of scopes with additional details used by Cost Management in the Azure portal.
     */
    @JvmName("froqdallilxotgsu")
    public suspend fun cache(`value`: List<SettingsPropertiesCacheArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cache = mapped
    }

    /**
     * @param argument Array of scopes with additional details used by Cost Management in the Azure portal.
     */
    @JvmName("bqensaemcrmaskcq")
    public suspend fun cache(argument: List<suspend SettingsPropertiesCacheArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SettingsPropertiesCacheArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.cache = mapped
    }

    /**
     * @param argument Array of scopes with additional details used by Cost Management in the Azure portal.
     */
    @JvmName("hbrqblcvhkrltvjn")
    public suspend fun cache(vararg argument: suspend SettingsPropertiesCacheArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SettingsPropertiesCacheArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.cache = mapped
    }

    /**
     * @param argument Array of scopes with additional details used by Cost Management in the Azure portal.
     */
    @JvmName("hcgvytpnwdvhxrkh")
    public suspend fun cache(argument: suspend SettingsPropertiesCacheArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SettingsPropertiesCacheArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.cache = mapped
    }

    /**
     * @param values Array of scopes with additional details used by Cost Management in the Azure portal.
     */
    @JvmName("lfloqktphthjkqtd")
    public suspend fun cache(vararg values: SettingsPropertiesCacheArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cache = mapped
    }

    /**
     * @param value Sets the default scope the current user will see when they sign into Azure Cost Management in the Azure portal.
     */
    @JvmName("gbqfkmlfygrnaxkc")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Name of the setting. Allowed values: myscope
     */
    @JvmName("nnlejavkbjmdeyep")
    public suspend fun settingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settingName = mapped
    }

    /**
     * @param value Indicates what scope Cost Management in the Azure portal should default to. Allowed values: LastUsed.
     */
    @JvmName("clxmnyqrmdidmheo")
    public suspend fun startOn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startOn = mapped
    }

    internal fun build(): SettingArgs = SettingArgs(
        cache = cache,
        scope = scope,
        settingName = settingName,
        startOn = startOn,
    )
}
