@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin

import com.pulumi.azurenative.costmanagement.ViewArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.AccumulatedType
import com.pulumi.azurenative.costmanagement.kotlin.enums.ChartType
import com.pulumi.azurenative.costmanagement.kotlin.enums.MetricType
import com.pulumi.azurenative.costmanagement.kotlin.enums.ReportTimeframeType
import com.pulumi.azurenative.costmanagement.kotlin.enums.ReportType
import com.pulumi.azurenative.costmanagement.kotlin.inputs.KpiPropertiesArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.KpiPropertiesArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.PivotPropertiesArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.PivotPropertiesArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.ReportConfigDatasetArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.ReportConfigDatasetArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.ReportConfigTimePeriodArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.ReportConfigTimePeriodArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * States and configurations of Cost Analysis.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2019-11-01.
 * Other available API versions: 2019-11-01, 2020-06-01, 2022-10-01, 2022-10-05-preview, 2023-04-01-preview, 2023-08-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### CreateOrUpdatePrivateView
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var view = new AzureNative.CostManagement.View("view", new()
 *     {
 *         Accumulated = "true",
 *         Chart = "Table",
 *         DataSet = new AzureNative.CostManagement.Inputs.ReportConfigDatasetArgs
 *         {
 *             Aggregation =
 *             {
 *                 { "totalCost", new AzureNative.CostManagement.Inputs.ReportConfigAggregationArgs
 *                 {
 *                     Function = "Sum",
 *                     Name = "PreTaxCost",
 *                 } },
 *             },
 *             Granularity = "Daily",
 *             Grouping = new() { },
 *             Sorting = new[]
 *             {
 *                 new AzureNative.CostManagement.Inputs.ReportConfigSortingArgs
 *                 {
 *                     Direction = "Ascending",
 *                     Name = "UsageDate",
 *                 },
 *             },
 *         },
 *         DisplayName = "swagger Example",
 *         ETag = "\"1d4ff9fe66f1d10\"",
 *         Kpis = new[]
 *         {
 *             new AzureNative.CostManagement.Inputs.KpiPropertiesArgs
 *             {
 *                 Enabled = true,
 *                 Type = "Forecast",
 *             },
 *             new AzureNative.CostManagement.Inputs.KpiPropertiesArgs
 *             {
 *                 Enabled = true,
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Consumption/budgets/swaggerDemo",
 *                 Type = "Budget",
 *             },
 *         },
 *         Metric = "ActualCost",
 *         Pivots = new[]
 *         {
 *             new AzureNative.CostManagement.Inputs.PivotPropertiesArgs
 *             {
 *                 Name = "ServiceName",
 *                 Type = "Dimension",
 *             },
 *             new AzureNative.CostManagement.Inputs.PivotPropertiesArgs
 *             {
 *                 Name = "MeterCategory",
 *                 Type = "Dimension",
 *             },
 *             new AzureNative.CostManagement.Inputs.PivotPropertiesArgs
 *             {
 *                 Name = "swaggerTagKey",
 *                 Type = "TagKey",
 *             },
 *         },
 *         Timeframe = "MonthToDate",
 *         Type = "Usage",
 *         ViewName = "swaggerExample",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := costmanagement.NewView(ctx, "view", &costmanagement.ViewArgs{
 * 			Accumulated: pulumi.String("true"),
 * 			Chart:       pulumi.String("Table"),
 * 			DataSet: costmanagement.ReportConfigDatasetResponse{
 * 				Aggregation: costmanagement.ReportConfigAggregationMap{
 * 					"totalCost": &costmanagement.ReportConfigAggregationArgs{
 * 						Function: pulumi.String("Sum"),
 * 						Name:     pulumi.String("PreTaxCost"),
 * 					},
 * 				},
 * 				Granularity: pulumi.String("Daily"),
 * 				Grouping:    costmanagement.ReportConfigGroupingArray{},
 * 				Sorting: costmanagement.ReportConfigSortingArray{
 * 					&costmanagement.ReportConfigSortingArgs{
 * 						Direction: pulumi.String("Ascending"),
 * 						Name:      pulumi.String("UsageDate"),
 * 					},
 * 				},
 * 			},
 * 			DisplayName: pulumi.String("swagger Example"),
 * 			ETag:        pulumi.String("\"1d4ff9fe66f1d10\""),
 * 			Kpis: []costmanagement.KpiPropertiesArgs{
 * 				{
 * 					Enabled: pulumi.Bool(true),
 * 					Type:    pulumi.String("Forecast"),
 * 				},
 * 				{
 * 					Enabled: pulumi.Bool(true),
 * 					Id:      pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Consumption/budgets/swaggerDemo"),
 * 					Type:    pulumi.String("Budget"),
 * 				},
 * 			},
 * 			Metric: pulumi.String("ActualCost"),
 * 			Pivots: []costmanagement.PivotPropertiesArgs{
 * 				{
 * 					Name: pulumi.String("ServiceName"),
 * 					Type: pulumi.String("Dimension"),
 * 				},
 * 				{
 * 					Name: pulumi.String("MeterCategory"),
 * 					Type: pulumi.String("Dimension"),
 * 				},
 * 				{
 * 					Name: pulumi.String("swaggerTagKey"),
 * 					Type: pulumi.String("TagKey"),
 * 				},
 * 			},
 * 			Timeframe: pulumi.String("MonthToDate"),
 * 			Type:      pulumi.String("Usage"),
 * 			ViewName:  pulumi.String("swaggerExample"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.View;
 * import com.pulumi.azurenative.costmanagement.ViewArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var view = new View("view", ViewArgs.builder()
 *             .accumulated("true")
 *             .chart("Table")
 *             .dataSet(Map.ofEntries(
 *                 Map.entry("aggregation", Map.of("totalCost", Map.ofEntries(
 *                     Map.entry("function", "Sum"),
 *                     Map.entry("name", "PreTaxCost")
 *                 ))),
 *                 Map.entry("granularity", "Daily"),
 *                 Map.entry("grouping", ),
 *                 Map.entry("sorting", Map.ofEntries(
 *                     Map.entry("direction", "Ascending"),
 *                     Map.entry("name", "UsageDate")
 *                 ))
 *             ))
 *             .displayName("swagger Example")
 *             .eTag("\"1d4ff9fe66f1d10\"")
 *             .kpis(
 *                 Map.ofEntries(
 *                     Map.entry("enabled", true),
 *                     Map.entry("type", "Forecast")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("enabled", true),
 *                     Map.entry("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Consumption/budgets/swaggerDemo"),
 *                     Map.entry("type", "Budget")
 *                 ))
 *             .metric("ActualCost")
 *             .pivots(
 *                 Map.ofEntries(
 *                     Map.entry("name", "ServiceName"),
 *                     Map.entry("type", "Dimension")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "MeterCategory"),
 *                     Map.entry("type", "Dimension")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "swaggerTagKey"),
 *                     Map.entry("type", "TagKey")
 *                 ))
 *             .timeframe("MonthToDate")
 *             .type("Usage")
 *             .viewName("swaggerExample")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:costmanagement:View swaggerExample /providers/Microsoft.CostManagement/views/{viewName}
 * ```
 * @property accumulated Show costs accumulated over time.
 * @property chart Chart type of the main view in Cost Analysis. Required.
 * @property dataSet Has definition for data in this report config.
 * @property dateRange Date range of the current view.
 * @property displayName User input name of the view. Required.
 * @property eTag eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
 * @property includeMonetaryCommitment If true, report includes monetary commitment.
 * @property kpis List of KPIs to show in Cost Analysis UI.
 * @property metric Metric to use when displaying costs.
 * @property modifiedOn Date when the user last modified this view.
 * @property pivots Configuration of 3 sub-views in the Cost Analysis UI.
 * @property scope Cost Management scope to save the view on. This includes 'subscriptions/{subscriptionId}' for subscription scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection scope, 'providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management Group scope, '/providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for ExternalBillingAccount scope, and '/providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for ExternalSubscription scope.
 * @property timePeriod Has time period for pulling data for the report.
 * @property timeframe The time frame for pulling data for the report. If custom, then a specific time period must be provided.
 * @property type The type of the report. Usage represents actual usage, forecast represents forecasted data and UsageAndForecast represents both usage and forecasted data. Actual usage and forecasted data can be differentiated based on dates.
 * @property viewName View name
 */
public data class ViewArgs(
    public val accumulated: Output<Either<String, AccumulatedType>>? = null,
    public val chart: Output<Either<String, ChartType>>? = null,
    public val dataSet: Output<ReportConfigDatasetArgs>? = null,
    public val dateRange: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val eTag: Output<String>? = null,
    public val includeMonetaryCommitment: Output<Boolean>? = null,
    public val kpis: Output<List<KpiPropertiesArgs>>? = null,
    public val metric: Output<Either<String, MetricType>>? = null,
    public val modifiedOn: Output<String>? = null,
    public val pivots: Output<List<PivotPropertiesArgs>>? = null,
    public val scope: Output<String>? = null,
    public val timePeriod: Output<ReportConfigTimePeriodArgs>? = null,
    public val timeframe: Output<Either<String, ReportTimeframeType>>? = null,
    public val type: Output<Either<String, ReportType>>? = null,
    public val viewName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.ViewArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.ViewArgs =
        com.pulumi.azurenative.costmanagement.ViewArgs.builder()
            .accumulated(
                accumulated?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .chart(
                chart?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .dataSet(dataSet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dateRange(dateRange?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .includeMonetaryCommitment(includeMonetaryCommitment?.applyValue({ args0 -> args0 }))
            .kpis(kpis?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .metric(
                metric?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .modifiedOn(modifiedOn?.applyValue({ args0 -> args0 }))
            .pivots(pivots?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .timePeriod(timePeriod?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeframe(
                timeframe?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .viewName(viewName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ViewArgs].
 */
@PulumiTagMarker
public class ViewArgsBuilder internal constructor() {
    private var accumulated: Output<Either<String, AccumulatedType>>? = null

    private var chart: Output<Either<String, ChartType>>? = null

    private var dataSet: Output<ReportConfigDatasetArgs>? = null

    private var dateRange: Output<String>? = null

    private var displayName: Output<String>? = null

    private var eTag: Output<String>? = null

    private var includeMonetaryCommitment: Output<Boolean>? = null

    private var kpis: Output<List<KpiPropertiesArgs>>? = null

    private var metric: Output<Either<String, MetricType>>? = null

    private var modifiedOn: Output<String>? = null

    private var pivots: Output<List<PivotPropertiesArgs>>? = null

    private var scope: Output<String>? = null

    private var timePeriod: Output<ReportConfigTimePeriodArgs>? = null

    private var timeframe: Output<Either<String, ReportTimeframeType>>? = null

    private var type: Output<Either<String, ReportType>>? = null

    private var viewName: Output<String>? = null

    /**
     * @param value Show costs accumulated over time.
     */
    @JvmName("jdqswsydfsknvmjs")
    public suspend fun accumulated(`value`: Output<Either<String, AccumulatedType>>) {
        this.accumulated = value
    }

    /**
     * @param value Chart type of the main view in Cost Analysis. Required.
     */
    @JvmName("cpwivuhyjutdexjg")
    public suspend fun chart(`value`: Output<Either<String, ChartType>>) {
        this.chart = value
    }

    /**
     * @param value Has definition for data in this report config.
     */
    @JvmName("igglaeftrfbsmdow")
    public suspend fun dataSet(`value`: Output<ReportConfigDatasetArgs>) {
        this.dataSet = value
    }

    /**
     * @param value Date range of the current view.
     */
    @JvmName("qnngmvvnqrtqfppc")
    public suspend fun dateRange(`value`: Output<String>) {
        this.dateRange = value
    }

    /**
     * @param value User input name of the view. Required.
     */
    @JvmName("frswbffdctdgkuaq")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
     */
    @JvmName("clwxicffltnggblk")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value If true, report includes monetary commitment.
     */
    @JvmName("oictqbxwimrxukdt")
    public suspend fun includeMonetaryCommitment(`value`: Output<Boolean>) {
        this.includeMonetaryCommitment = value
    }

    /**
     * @param value List of KPIs to show in Cost Analysis UI.
     */
    @JvmName("imyusdlgmxvsnjyl")
    public suspend fun kpis(`value`: Output<List<KpiPropertiesArgs>>) {
        this.kpis = value
    }

    @JvmName("vdprrrhauvsdlmua")
    public suspend fun kpis(vararg values: Output<KpiPropertiesArgs>) {
        this.kpis = Output.all(values.asList())
    }

    /**
     * @param values List of KPIs to show in Cost Analysis UI.
     */
    @JvmName("diieifehtfcvweug")
    public suspend fun kpis(values: List<Output<KpiPropertiesArgs>>) {
        this.kpis = Output.all(values)
    }

    /**
     * @param value Metric to use when displaying costs.
     */
    @JvmName("xdthlypivvdfrpxg")
    public suspend fun metric(`value`: Output<Either<String, MetricType>>) {
        this.metric = value
    }

    /**
     * @param value Date when the user last modified this view.
     */
    @JvmName("lqxfvheqqpmemwvy")
    public suspend fun modifiedOn(`value`: Output<String>) {
        this.modifiedOn = value
    }

    /**
     * @param value Configuration of 3 sub-views in the Cost Analysis UI.
     */
    @JvmName("bemjpaqgfrgnbiye")
    public suspend fun pivots(`value`: Output<List<PivotPropertiesArgs>>) {
        this.pivots = value
    }

    @JvmName("jmsogtrewnqscdmp")
    public suspend fun pivots(vararg values: Output<PivotPropertiesArgs>) {
        this.pivots = Output.all(values.asList())
    }

    /**
     * @param values Configuration of 3 sub-views in the Cost Analysis UI.
     */
    @JvmName("rgfykanabyefgtmg")
    public suspend fun pivots(values: List<Output<PivotPropertiesArgs>>) {
        this.pivots = Output.all(values)
    }

    /**
     * @param value Cost Management scope to save the view on. This includes 'subscriptions/{subscriptionId}' for subscription scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection scope, 'providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management Group scope, '/providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for ExternalBillingAccount scope, and '/providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for ExternalSubscription scope.
     */
    @JvmName("xcdpbiutpbmqaceo")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value Has time period for pulling data for the report.
     */
    @JvmName("xansowpmrmaerpru")
    public suspend fun timePeriod(`value`: Output<ReportConfigTimePeriodArgs>) {
        this.timePeriod = value
    }

    /**
     * @param value The time frame for pulling data for the report. If custom, then a specific time period must be provided.
     */
    @JvmName("redwjgiammmuwwxj")
    public suspend fun timeframe(`value`: Output<Either<String, ReportTimeframeType>>) {
        this.timeframe = value
    }

    /**
     * @param value The type of the report. Usage represents actual usage, forecast represents forecasted data and UsageAndForecast represents both usage and forecasted data. Actual usage and forecasted data can be differentiated based on dates.
     */
    @JvmName("cdtyokoqkhyfkgab")
    public suspend fun type(`value`: Output<Either<String, ReportType>>) {
        this.type = value
    }

    /**
     * @param value View name
     */
    @JvmName("uhqsivirdhbgdfrc")
    public suspend fun viewName(`value`: Output<String>) {
        this.viewName = value
    }

    /**
     * @param value Show costs accumulated over time.
     */
    @JvmName("xdmjodmfsyckomlf")
    public suspend fun accumulated(`value`: Either<String, AccumulatedType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accumulated = mapped
    }

    /**
     * @param value Show costs accumulated over time.
     */
    @JvmName("ljtyfguoslwhncer")
    public fun accumulated(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AccumulatedType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accumulated = mapped
    }

    /**
     * @param value Show costs accumulated over time.
     */
    @JvmName("lyprikfouyywtecp")
    public fun accumulated(`value`: AccumulatedType) {
        val toBeMapped = Either.ofRight<String, AccumulatedType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accumulated = mapped
    }

    /**
     * @param value Chart type of the main view in Cost Analysis. Required.
     */
    @JvmName("wrksyhxybrjqbyny")
    public suspend fun chart(`value`: Either<String, ChartType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.chart = mapped
    }

    /**
     * @param value Chart type of the main view in Cost Analysis. Required.
     */
    @JvmName("tilefqspensnusmu")
    public fun chart(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ChartType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.chart = mapped
    }

    /**
     * @param value Chart type of the main view in Cost Analysis. Required.
     */
    @JvmName("ynyhlxjaadghthgp")
    public fun chart(`value`: ChartType) {
        val toBeMapped = Either.ofRight<String, ChartType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.chart = mapped
    }

    /**
     * @param value Has definition for data in this report config.
     */
    @JvmName("jjkytaimlpypgaev")
    public suspend fun dataSet(`value`: ReportConfigDatasetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSet = mapped
    }

    /**
     * @param argument Has definition for data in this report config.
     */
    @JvmName("nbeilbvwefqkklxk")
    public suspend fun dataSet(argument: suspend ReportConfigDatasetArgsBuilder.() -> Unit) {
        val toBeMapped = ReportConfigDatasetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataSet = mapped
    }

    /**
     * @param value Date range of the current view.
     */
    @JvmName("frapxqbfhjginglp")
    public suspend fun dateRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dateRange = mapped
    }

    /**
     * @param value User input name of the view. Required.
     */
    @JvmName("rflciyisavpdysjd")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
     */
    @JvmName("huyhlqtfpeawgcrf")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value If true, report includes monetary commitment.
     */
    @JvmName("biojberwyewedqor")
    public suspend fun includeMonetaryCommitment(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeMonetaryCommitment = mapped
    }

    /**
     * @param value List of KPIs to show in Cost Analysis UI.
     */
    @JvmName("kybismlwxqadxigh")
    public suspend fun kpis(`value`: List<KpiPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kpis = mapped
    }

    /**
     * @param argument List of KPIs to show in Cost Analysis UI.
     */
    @JvmName("qvbhquabhhiqylao")
    public suspend fun kpis(argument: List<suspend KpiPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            KpiPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.kpis = mapped
    }

    /**
     * @param argument List of KPIs to show in Cost Analysis UI.
     */
    @JvmName("uhdfasxgoxcqxsew")
    public suspend fun kpis(vararg argument: suspend KpiPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            KpiPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.kpis = mapped
    }

    /**
     * @param argument List of KPIs to show in Cost Analysis UI.
     */
    @JvmName("xkwvlunsivlgxoga")
    public suspend fun kpis(argument: suspend KpiPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(KpiPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.kpis = mapped
    }

    /**
     * @param values List of KPIs to show in Cost Analysis UI.
     */
    @JvmName("enysmnuchdocxcrw")
    public suspend fun kpis(vararg values: KpiPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kpis = mapped
    }

    /**
     * @param value Metric to use when displaying costs.
     */
    @JvmName("pdihkyjklafwbhjh")
    public suspend fun metric(`value`: Either<String, MetricType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metric = mapped
    }

    /**
     * @param value Metric to use when displaying costs.
     */
    @JvmName("wviilfhayrfgolvb")
    public fun metric(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MetricType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metric = mapped
    }

    /**
     * @param value Metric to use when displaying costs.
     */
    @JvmName("lhlkcrscqreynsyr")
    public fun metric(`value`: MetricType) {
        val toBeMapped = Either.ofRight<String, MetricType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metric = mapped
    }

    /**
     * @param value Date when the user last modified this view.
     */
    @JvmName("luinafxevoyjkkvx")
    public suspend fun modifiedOn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifiedOn = mapped
    }

    /**
     * @param value Configuration of 3 sub-views in the Cost Analysis UI.
     */
    @JvmName("pslilqnpckfxfasq")
    public suspend fun pivots(`value`: List<PivotPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pivots = mapped
    }

    /**
     * @param argument Configuration of 3 sub-views in the Cost Analysis UI.
     */
    @JvmName("wcoiqbjnuhqijcug")
    public suspend fun pivots(argument: List<suspend PivotPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PivotPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pivots = mapped
    }

    /**
     * @param argument Configuration of 3 sub-views in the Cost Analysis UI.
     */
    @JvmName("vebhakutxiicguoy")
    public suspend fun pivots(vararg argument: suspend PivotPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PivotPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pivots = mapped
    }

    /**
     * @param argument Configuration of 3 sub-views in the Cost Analysis UI.
     */
    @JvmName("hbgllwfbodnrbmwq")
    public suspend fun pivots(argument: suspend PivotPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PivotPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.pivots = mapped
    }

    /**
     * @param values Configuration of 3 sub-views in the Cost Analysis UI.
     */
    @JvmName("bixjfnsxrnnwovld")
    public suspend fun pivots(vararg values: PivotPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pivots = mapped
    }

    /**
     * @param value Cost Management scope to save the view on. This includes 'subscriptions/{subscriptionId}' for subscription scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection scope, 'providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management Group scope, '/providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for ExternalBillingAccount scope, and '/providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for ExternalSubscription scope.
     */
    @JvmName("rpofxcytqgnjkavv")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Has time period for pulling data for the report.
     */
    @JvmName("lfmahmeppehyvquv")
    public suspend fun timePeriod(`value`: ReportConfigTimePeriodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timePeriod = mapped
    }

    /**
     * @param argument Has time period for pulling data for the report.
     */
    @JvmName("idljryruifjcbqjh")
    public suspend fun timePeriod(argument: suspend ReportConfigTimePeriodArgsBuilder.() -> Unit) {
        val toBeMapped = ReportConfigTimePeriodArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timePeriod = mapped
    }

    /**
     * @param value The time frame for pulling data for the report. If custom, then a specific time period must be provided.
     */
    @JvmName("xbotwvkerlhuxoqy")
    public suspend fun timeframe(`value`: Either<String, ReportTimeframeType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeframe = mapped
    }

    /**
     * @param value The time frame for pulling data for the report. If custom, then a specific time period must be provided.
     */
    @JvmName("sblvhfxxpxmxfywv")
    public fun timeframe(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ReportTimeframeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeframe = mapped
    }

    /**
     * @param value The time frame for pulling data for the report. If custom, then a specific time period must be provided.
     */
    @JvmName("abeajtjpatpovkra")
    public fun timeframe(`value`: ReportTimeframeType) {
        val toBeMapped = Either.ofRight<String, ReportTimeframeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeframe = mapped
    }

    /**
     * @param value The type of the report. Usage represents actual usage, forecast represents forecasted data and UsageAndForecast represents both usage and forecasted data. Actual usage and forecasted data can be differentiated based on dates.
     */
    @JvmName("mimwmcxhgljtjdgl")
    public suspend fun type(`value`: Either<String, ReportType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the report. Usage represents actual usage, forecast represents forecasted data and UsageAndForecast represents both usage and forecasted data. Actual usage and forecasted data can be differentiated based on dates.
     */
    @JvmName("wvugnmindvywcuyc")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ReportType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the report. Usage represents actual usage, forecast represents forecasted data and UsageAndForecast represents both usage and forecasted data. Actual usage and forecasted data can be differentiated based on dates.
     */
    @JvmName("pywpaluhcaorgcfl")
    public fun type(`value`: ReportType) {
        val toBeMapped = Either.ofRight<String, ReportType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value View name
     */
    @JvmName("kelvqnjsepxddbrq")
    public suspend fun viewName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.viewName = mapped
    }

    internal fun build(): ViewArgs = ViewArgs(
        accumulated = accumulated,
        chart = chart,
        dataSet = dataSet,
        dateRange = dateRange,
        displayName = displayName,
        eTag = eTag,
        includeMonetaryCommitment = includeMonetaryCommitment,
        kpis = kpis,
        metric = metric,
        modifiedOn = modifiedOn,
        pivots = pivots,
        scope = scope,
        timePeriod = timePeriod,
        timeframe = timeframe,
        type = type,
        viewName = viewName,
    )
}
