@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin

import com.pulumi.azurenative.costmanagement.kotlin.outputs.KpiPropertiesResponse
import com.pulumi.azurenative.costmanagement.kotlin.outputs.PivotPropertiesResponse
import com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportConfigDatasetResponse
import com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportConfigTimePeriodResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.costmanagement.kotlin.outputs.KpiPropertiesResponse.Companion.toKotlin as kpiPropertiesResponseToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.PivotPropertiesResponse.Companion.toKotlin as pivotPropertiesResponseToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportConfigDatasetResponse.Companion.toKotlin as reportConfigDatasetResponseToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportConfigTimePeriodResponse.Companion.toKotlin as reportConfigTimePeriodResponseToKotlin

/**
 * Builder for [ViewByScope].
 */
@PulumiTagMarker
public class ViewByScopeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ViewByScopeArgs = ViewByScopeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ViewByScopeArgsBuilder.() -> Unit) {
        val builder = ViewByScopeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ViewByScope {
        val builtJavaResource =
            com.pulumi.azurenative.costmanagement.ViewByScope(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ViewByScope(builtJavaResource)
    }
}

/**
 * States and configurations of Cost Analysis.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2019-11-01.
 * Other available API versions: 2019-11-01, 2020-06-01, 2022-10-01, 2022-10-05-preview, 2023-04-01-preview, 2023-08-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### ResourceGroupCreateOrUpdateView
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var viewByScope = new AzureNative.CostManagement.ViewByScope("viewByScope", new()
 *     {
 *         Accumulated = "true",
 *         Chart = "Table",
 *         DataSet = new AzureNative.CostManagement.Inputs.ReportConfigDatasetArgs
 *         {
 *             Aggregation =
 *             {
 *                 { "totalCost", new AzureNative.CostManagement.Inputs.ReportConfigAggregationArgs
 *                 {
 *                     Function = "Sum",
 *                     Name = "PreTaxCost",
 *                 } },
 *             },
 *             Granularity = "Daily",
 *             Grouping = new() { },
 *             Sorting = new[]
 *             {
 *                 new AzureNative.CostManagement.Inputs.ReportConfigSortingArgs
 *                 {
 *                     Direction = "Ascending",
 *                     Name = "UsageDate",
 *                 },
 *             },
 *         },
 *         DisplayName = "swagger Example",
 *         ETag = "\"1d4ff9fe66f1d10\"",
 *         Kpis = new[]
 *         {
 *             new AzureNative.CostManagement.Inputs.KpiPropertiesArgs
 *             {
 *                 Enabled = true,
 *                 Type = "Forecast",
 *             },
 *             new AzureNative.CostManagement.Inputs.KpiPropertiesArgs
 *             {
 *                 Enabled = true,
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Consumption/budgets/swaggerDemo",
 *                 Type = "Budget",
 *             },
 *         },
 *         Metric = "ActualCost",
 *         Pivots = new[]
 *         {
 *             new AzureNative.CostManagement.Inputs.PivotPropertiesArgs
 *             {
 *                 Name = "ServiceName",
 *                 Type = "Dimension",
 *             },
 *             new AzureNative.CostManagement.Inputs.PivotPropertiesArgs
 *             {
 *                 Name = "MeterCategory",
 *                 Type = "Dimension",
 *             },
 *             new AzureNative.CostManagement.Inputs.PivotPropertiesArgs
 *             {
 *                 Name = "swaggerTagKey",
 *                 Type = "TagKey",
 *             },
 *         },
 *         Scope = "subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG",
 *         Timeframe = "MonthToDate",
 *         Type = "Usage",
 *         ViewName = "swaggerExample",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := costmanagement.NewViewByScope(ctx, "viewByScope", &costmanagement.ViewByScopeArgs{
 * 			Accumulated: pulumi.String("true"),
 * 			Chart:       pulumi.String("Table"),
 * 			DataSet: costmanagement.ReportConfigDatasetResponse{
 * 				Aggregation: costmanagement.ReportConfigAggregationMap{
 * 					"totalCost": &costmanagement.ReportConfigAggregationArgs{
 * 						Function: pulumi.String("Sum"),
 * 						Name:     pulumi.String("PreTaxCost"),
 * 					},
 * 				},
 * 				Granularity: pulumi.String("Daily"),
 * 				Grouping:    costmanagement.ReportConfigGroupingArray{},
 * 				Sorting: costmanagement.ReportConfigSortingArray{
 * 					&costmanagement.ReportConfigSortingArgs{
 * 						Direction: pulumi.String("Ascending"),
 * 						Name:      pulumi.String("UsageDate"),
 * 					},
 * 				},
 * 			},
 * 			DisplayName: pulumi.String("swagger Example"),
 * 			ETag:        pulumi.String("\"1d4ff9fe66f1d10\""),
 * 			Kpis: []costmanagement.KpiPropertiesArgs{
 * 				{
 * 					Enabled: pulumi.Bool(true),
 * 					Type:    pulumi.String("Forecast"),
 * 				},
 * 				{
 * 					Enabled: pulumi.Bool(true),
 * 					Id:      pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Consumption/budgets/swaggerDemo"),
 * 					Type:    pulumi.String("Budget"),
 * 				},
 * 			},
 * 			Metric: pulumi.String("ActualCost"),
 * 			Pivots: []costmanagement.PivotPropertiesArgs{
 * 				{
 * 					Name: pulumi.String("ServiceName"),
 * 					Type: pulumi.String("Dimension"),
 * 				},
 * 				{
 * 					Name: pulumi.String("MeterCategory"),
 * 					Type: pulumi.String("Dimension"),
 * 				},
 * 				{
 * 					Name: pulumi.String("swaggerTagKey"),
 * 					Type: pulumi.String("TagKey"),
 * 				},
 * 			},
 * 			Scope:     pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG"),
 * 			Timeframe: pulumi.String("MonthToDate"),
 * 			Type:      pulumi.String("Usage"),
 * 			ViewName:  pulumi.String("swaggerExample"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.ViewByScope;
 * import com.pulumi.azurenative.costmanagement.ViewByScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var viewByScope = new ViewByScope("viewByScope", ViewByScopeArgs.builder()
 *             .accumulated("true")
 *             .chart("Table")
 *             .dataSet(Map.ofEntries(
 *                 Map.entry("aggregation", Map.of("totalCost", Map.ofEntries(
 *                     Map.entry("function", "Sum"),
 *                     Map.entry("name", "PreTaxCost")
 *                 ))),
 *                 Map.entry("granularity", "Daily"),
 *                 Map.entry("grouping", ),
 *                 Map.entry("sorting", Map.ofEntries(
 *                     Map.entry("direction", "Ascending"),
 *                     Map.entry("name", "UsageDate")
 *                 ))
 *             ))
 *             .displayName("swagger Example")
 *             .eTag("\"1d4ff9fe66f1d10\"")
 *             .kpis(
 *                 Map.ofEntries(
 *                     Map.entry("enabled", true),
 *                     Map.entry("type", "Forecast")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("enabled", true),
 *                     Map.entry("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Consumption/budgets/swaggerDemo"),
 *                     Map.entry("type", "Budget")
 *                 ))
 *             .metric("ActualCost")
 *             .pivots(
 *                 Map.ofEntries(
 *                     Map.entry("name", "ServiceName"),
 *                     Map.entry("type", "Dimension")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "MeterCategory"),
 *                     Map.entry("type", "Dimension")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "swaggerTagKey"),
 *                     Map.entry("type", "TagKey")
 *                 ))
 *             .scope("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG")
 *             .timeframe("MonthToDate")
 *             .type("Usage")
 *             .viewName("swaggerExample")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:costmanagement:ViewByScope swaggerExample /{scope}/providers/Microsoft.CostManagement/views/{viewName}
 * ```
 */
public class ViewByScope internal constructor(
    override val javaResource: com.pulumi.azurenative.costmanagement.ViewByScope,
) : KotlinCustomResource(javaResource, ViewByScopeMapper) {
    /**
     * Show costs accumulated over time.
     */
    public val accumulated: Output<String>?
        get() = javaResource.accumulated().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Chart type of the main view in Cost Analysis. Required.
     */
    public val chart: Output<String>?
        get() = javaResource.chart().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Date the user created this view.
     */
    public val createdOn: Output<String>
        get() = javaResource.createdOn().applyValue({ args0 -> args0 })

    /**
     * Currency of the current view.
     */
    public val currency: Output<String>
        get() = javaResource.currency().applyValue({ args0 -> args0 })

    /**
     * Has definition for data in this report config.
     */
    public val dataSet: Output<ReportConfigDatasetResponse>?
        get() = javaResource.dataSet().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    reportConfigDatasetResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Date range of the current view.
     */
    public val dateRange: Output<String>?
        get() = javaResource.dateRange().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * User input name of the view. Required.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
     */
    public val eTag: Output<String>?
        get() = javaResource.eTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * If true, report includes monetary commitment.
     */
    public val includeMonetaryCommitment: Output<Boolean>?
        get() = javaResource.includeMonetaryCommitment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of KPIs to show in Cost Analysis UI.
     */
    public val kpis: Output<List<KpiPropertiesResponse>>?
        get() = javaResource.kpis().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> kpiPropertiesResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Metric to use when displaying costs.
     */
    public val metric: Output<String>?
        get() = javaResource.metric().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Date when the user last modified this view.
     */
    public val modifiedOn: Output<String>?
        get() = javaResource.modifiedOn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Configuration of 3 sub-views in the Cost Analysis UI.
     */
    public val pivots: Output<List<PivotPropertiesResponse>>?
        get() = javaResource.pivots().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> pivotPropertiesResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Cost Management scope to save the view on. This includes 'subscriptions/{subscriptionId}' for subscription scope, 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for BillingProfile scope, 'providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for InvoiceSection scope, 'providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management Group scope, '/providers/Microsoft.CostManagement/externalBillingAccounts/{externalBillingAccountName}' for ExternalBillingAccount scope, and '/providers/Microsoft.CostManagement/externalSubscriptions/{externalSubscriptionName}' for ExternalSubscription scope.
     */
    public val scope: Output<String>?
        get() = javaResource.scope().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Has time period for pulling data for the report.
     */
    public val timePeriod: Output<ReportConfigTimePeriodResponse>?
        get() = javaResource.timePeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    reportConfigTimePeriodResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The time frame for pulling data for the report. If custom, then a specific time period must be provided.
     */
    public val timeframe: Output<String>
        get() = javaResource.timeframe().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ViewByScopeMapper : ResourceMapper<ViewByScope> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.costmanagement.ViewByScope::class == javaResource::class

    override fun map(javaResource: Resource): ViewByScope = ViewByScope(
        javaResource as
            com.pulumi.azurenative.costmanagement.ViewByScope,
    )
}

/**
 * @see [ViewByScope].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ViewByScope].
 */
public suspend fun viewByScope(name: String, block: suspend ViewByScopeResourceBuilder.() -> Unit):
    ViewByScope {
    val builder = ViewByScopeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ViewByScope].
 * @param name The _unique_ name of the resulting resource.
 */
public fun viewByScope(name: String): ViewByScope {
    val builder = ViewByScopeResourceBuilder()
    builder.name(name)
    return builder.build()
}
