@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Frequency of a notification. Represents how long the notification will be silent after triggering an alert for a threshold breach. If not specified, the frequency will be set by default based on the timeGrain (Weekly when timeGrain: Last7Days, Monthly when timeGrain: Last30Days).
 *  Supported for CategoryType(s): ReservationUtilization.
 */
public enum class Frequency(
    public val javaValue: com.pulumi.azurenative.costmanagement.enums.Frequency,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.enums.Frequency> {
    /**
     * After the threshold breaches and an Alert is fired, no further alerts will be sent until the next calendar day.
     */
    Daily(com.pulumi.azurenative.costmanagement.enums.Frequency.Daily),

    /**
     * After the threshold breaches and an Alert is fired, no further alerts will be sent for 7 calendar days.
     */
    Weekly(com.pulumi.azurenative.costmanagement.enums.Frequency.Weekly),

    /**
     * After the threshold breaches and an Alert is fired, no further alerts will be sent for 30 calendar days.
     */
    Monthly(com.pulumi.azurenative.costmanagement.enums.Frequency.Monthly),
    ;

    override fun toJava(): com.pulumi.azurenative.costmanagement.enums.Frequency = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.enums.Frequency): Frequency =
            Frequency.values().first { it.javaValue == javaType }
    }
}
