@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of the report. Usage represents actual usage, forecast represents forecasted data and UsageAndForecast represents both usage and forecasted data. Actual usage and forecasted data can be differentiated based on dates.
 */
public enum class ReportType(
    public val javaValue: com.pulumi.azurenative.costmanagement.enums.ReportType,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.enums.ReportType> {
    Usage(com.pulumi.azurenative.costmanagement.enums.ReportType.Usage),
    ;

    override fun toJava(): com.pulumi.azurenative.costmanagement.enums.ReportType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.enums.ReportType):
            ReportType = ReportType.values().first { it.javaValue == javaType }
    }
}
