@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.BudgetFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * May be used to filter budgets by user-specified dimensions and/or tags.
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 * @property and The logical "AND" expression. Must have at least 2 items.
 *  Supported for CategoryType(s): Cost.
 * @property dimensions Has comparison expression for a dimension.
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 * Supported dimension names for **CategoryType: ReservationUtilization**
 * - ReservationId
 * - ReservedResourceType
 * @property tags Has comparison expression for a tag.
 *  Supported for CategoryType(s): Cost.
 */
public data class BudgetFilterArgs(
    public val and: Output<List<BudgetFilterPropertiesArgs>>? = null,
    public val dimensions: Output<BudgetComparisonExpressionArgs>? = null,
    public val tags: Output<BudgetComparisonExpressionArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.BudgetFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.BudgetFilterArgs =
        com.pulumi.azurenative.costmanagement.inputs.BudgetFilterArgs.builder()
            .and(and?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .dimensions(dimensions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BudgetFilterArgs].
 */
@PulumiTagMarker
public class BudgetFilterArgsBuilder internal constructor() {
    private var and: Output<List<BudgetFilterPropertiesArgs>>? = null

    private var dimensions: Output<BudgetComparisonExpressionArgs>? = null

    private var tags: Output<BudgetComparisonExpressionArgs>? = null

    /**
     * @param value The logical "AND" expression. Must have at least 2 items.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("rabhbafhlxkcuaxj")
    public suspend fun and(`value`: Output<List<BudgetFilterPropertiesArgs>>) {
        this.and = value
    }

    @JvmName("fjipvcmudxxdaivf")
    public suspend fun and(vararg values: Output<BudgetFilterPropertiesArgs>) {
        this.and = Output.all(values.asList())
    }

    /**
     * @param values The logical "AND" expression. Must have at least 2 items.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("ngblvwbqjgcwhlas")
    public suspend fun and(values: List<Output<BudgetFilterPropertiesArgs>>) {
        this.and = Output.all(values)
    }

    /**
     * @param value Has comparison expression for a dimension.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     * Supported dimension names for **CategoryType: ReservationUtilization**
     * - ReservationId
     * - ReservedResourceType
     */
    @JvmName("rgfgakphhturipiq")
    public suspend fun dimensions(`value`: Output<BudgetComparisonExpressionArgs>) {
        this.dimensions = value
    }

    /**
     * @param value Has comparison expression for a tag.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("rogjmcxwyqxwpstk")
    public suspend fun tags(`value`: Output<BudgetComparisonExpressionArgs>) {
        this.tags = value
    }

    /**
     * @param value The logical "AND" expression. Must have at least 2 items.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("qtyhdddjjyppjcrx")
    public suspend fun and(`value`: List<BudgetFilterPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.and = mapped
    }

    /**
     * @param argument The logical "AND" expression. Must have at least 2 items.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("qhtgherwsdkniykv")
    public suspend fun and(argument: List<suspend BudgetFilterPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BudgetFilterPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.and = mapped
    }

    /**
     * @param argument The logical "AND" expression. Must have at least 2 items.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("pqcblbaulndnmibc")
    public suspend fun and(vararg argument: suspend BudgetFilterPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BudgetFilterPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.and = mapped
    }

    /**
     * @param argument The logical "AND" expression. Must have at least 2 items.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("jqeqhipxrqccvueo")
    public suspend fun and(argument: suspend BudgetFilterPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BudgetFilterPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.and = mapped
    }

    /**
     * @param values The logical "AND" expression. Must have at least 2 items.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("mmnfgogoxnfkmcyd")
    public suspend fun and(vararg values: BudgetFilterPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.and = mapped
    }

    /**
     * @param value Has comparison expression for a dimension.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     * Supported dimension names for **CategoryType: ReservationUtilization**
     * - ReservationId
     * - ReservedResourceType
     */
    @JvmName("uqvwjpwbxqnfommm")
    public suspend fun dimensions(`value`: BudgetComparisonExpressionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param argument Has comparison expression for a dimension.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     * Supported dimension names for **CategoryType: ReservationUtilization**
     * - ReservationId
     * - ReservedResourceType
     */
    @JvmName("nukomtlicxkqrexr")
    public suspend
    fun dimensions(argument: suspend BudgetComparisonExpressionArgsBuilder.() -> Unit) {
        val toBeMapped = BudgetComparisonExpressionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param value Has comparison expression for a tag.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("fffqkrbmkrkxwpja")
    public suspend fun tags(`value`: BudgetComparisonExpressionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Has comparison expression for a tag.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("yfepwyyctsktnkfh")
    public suspend fun tags(argument: suspend BudgetComparisonExpressionArgsBuilder.() -> Unit) {
        val toBeMapped = BudgetComparisonExpressionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): BudgetFilterArgs = BudgetFilterArgs(
        and = and,
        dimensions = dimensions,
        tags = tags,
    )
}
