@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ExportTimePeriodArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The date range for data in the export. This should only be specified with timeFrame set to 'Custom'. The maximum date range is 3 months.
 * @property from The start date for export data.
 * @property to The end date for export data.
 */
public data class ExportTimePeriodArgs(
    public val from: Output<String>,
    public val to: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ExportTimePeriodArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.ExportTimePeriodArgs =
        com.pulumi.azurenative.costmanagement.inputs.ExportTimePeriodArgs.builder()
            .from(from.applyValue({ args0 -> args0 }))
            .to(to.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExportTimePeriodArgs].
 */
@PulumiTagMarker
public class ExportTimePeriodArgsBuilder internal constructor() {
    private var from: Output<String>? = null

    private var to: Output<String>? = null

    /**
     * @param value The start date for export data.
     */
    @JvmName("dgmcudblteviymmg")
    public suspend fun from(`value`: Output<String>) {
        this.from = value
    }

    /**
     * @param value The end date for export data.
     */
    @JvmName("ljovprgnebabmntn")
    public suspend fun to(`value`: Output<String>) {
        this.to = value
    }

    /**
     * @param value The start date for export data.
     */
    @JvmName("eakdtxqdxjrlpuxo")
    public suspend fun from(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.from = mapped
    }

    /**
     * @param value The end date for export data.
     */
    @JvmName("mkqopvmlgivcrruu")
    public suspend fun to(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.to = mapped
    }

    internal fun build(): ExportTimePeriodArgs = ExportTimePeriodArgs(
        from = from ?: throw PulumiNullFieldException("from"),
        to = to ?: throw PulumiNullFieldException("to"),
    )
}
