@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.GetBudgetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property budgetName Budget Name.
 * @property scope The scope associated with budget operations.
 *  Supported scopes for **CategoryType: Cost**
 *  Azure RBAC Scopes:
 * - '/subscriptions/{subscriptionId}/' for subscription scope
 * - '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope
 * - '/providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management Group scope
 *  EA (Enterprise Agreement) Scopes:
 * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope
 * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope
 * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope
 *  MCA (Modern Customer Agreement) Scopes:
 * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope
 * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billingProfile scope
 * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}' for invoiceSection scope
 * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' for customer scope (CSP only)
 *  Supported scopes for **CategoryType: ReservationUtilization**
 *  EA (Enterprise Agreement) Scopes:
 * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account Scope
 * MCA (Modern Customer Agreement) Scopes:
 * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billingProfile scope (non-CSP only)
 * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' for customer scope (CSP only)
 */
public data class GetBudgetPlainArgs(
    public val budgetName: String,
    public val scope: String,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.GetBudgetPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.GetBudgetPlainArgs =
        com.pulumi.azurenative.costmanagement.inputs.GetBudgetPlainArgs.builder()
            .budgetName(budgetName.let({ args0 -> args0 }))
            .scope(scope.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBudgetPlainArgs].
 */
@PulumiTagMarker
public class GetBudgetPlainArgsBuilder internal constructor() {
    private var budgetName: String? = null

    private var scope: String? = null

    /**
     * @param value Budget Name.
     */
    @JvmName("oinyimugpgqgvjoi")
    public suspend fun budgetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.budgetName = mapped
    }

    /**
     * @param value The scope associated with budget operations.
     *  Supported scopes for **CategoryType: Cost**
     *  Azure RBAC Scopes:
     * - '/subscriptions/{subscriptionId}/' for subscription scope
     * - '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope
     * - '/providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management Group scope
     *  EA (Enterprise Agreement) Scopes:
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope
     *  MCA (Modern Customer Agreement) Scopes:
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billingProfile scope
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}' for invoiceSection scope
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' for customer scope (CSP only)
     *  Supported scopes for **CategoryType: ReservationUtilization**
     *  EA (Enterprise Agreement) Scopes:
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account Scope
     * MCA (Modern Customer Agreement) Scopes:
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billingProfile scope (non-CSP only)
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' for customer scope (CSP only)
     */
    @JvmName("rljpeynuocjpfgnv")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scope = mapped
    }

    internal fun build(): GetBudgetPlainArgs = GetBudgetPlainArgs(
        budgetName = budgetName ?: throw PulumiNullFieldException("budgetName"),
        scope = scope ?: throw PulumiNullFieldException("scope"),
    )
}
