@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.GetCostAllocationRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property billingAccountId BillingAccount ID
 * @property ruleName Cost allocation rule name. The name cannot include spaces or any non alphanumeric characters other than '_' and '-'. The max length is 260 characters.
 */
public data class GetCostAllocationRulePlainArgs(
    public val billingAccountId: String,
    public val ruleName: String,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.GetCostAllocationRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.GetCostAllocationRulePlainArgs =
        com.pulumi.azurenative.costmanagement.inputs.GetCostAllocationRulePlainArgs.builder()
            .billingAccountId(billingAccountId.let({ args0 -> args0 }))
            .ruleName(ruleName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCostAllocationRulePlainArgs].
 */
@PulumiTagMarker
public class GetCostAllocationRulePlainArgsBuilder internal constructor() {
    private var billingAccountId: String? = null

    private var ruleName: String? = null

    /**
     * @param value BillingAccount ID
     */
    @JvmName("poavbpafajltdjvk")
    public suspend fun billingAccountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.billingAccountId = mapped
    }

    /**
     * @param value Cost allocation rule name. The name cannot include spaces or any non alphanumeric characters other than '_' and '-'. The max length is 260 characters.
     */
    @JvmName("rmbuohuuwnxlkywy")
    public suspend fun ruleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleName = mapped
    }

    internal fun build(): GetCostAllocationRulePlainArgs = GetCostAllocationRulePlainArgs(
        billingAccountId = billingAccountId ?: throw PulumiNullFieldException("billingAccountId"),
        ruleName = ruleName ?: throw PulumiNullFieldException("ruleName"),
    )
}
