@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.GetReportByDepartmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property departmentId Department ID
 * @property reportName Report Name.
 */
public data class GetReportByDepartmentPlainArgs(
    public val departmentId: String,
    public val reportName: String,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.GetReportByDepartmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.GetReportByDepartmentPlainArgs =
        com.pulumi.azurenative.costmanagement.inputs.GetReportByDepartmentPlainArgs.builder()
            .departmentId(departmentId.let({ args0 -> args0 }))
            .reportName(reportName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReportByDepartmentPlainArgs].
 */
@PulumiTagMarker
public class GetReportByDepartmentPlainArgsBuilder internal constructor() {
    private var departmentId: String? = null

    private var reportName: String? = null

    /**
     * @param value Department ID
     */
    @JvmName("bxuvkixevaarkdys")
    public suspend fun departmentId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.departmentId = mapped
    }

    /**
     * @param value Report Name.
     */
    @JvmName("egoihqeorlhhdipo")
    public suspend fun reportName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.reportName = mapped
    }

    internal fun build(): GetReportByDepartmentPlainArgs = GetReportByDepartmentPlainArgs(
        departmentId = departmentId ?: throw PulumiNullFieldException("departmentId"),
        reportName = reportName ?: throw PulumiNullFieldException("reportName"),
    )
}
