@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ReportConfigGroupingArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.QueryColumnType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The group by expression to be used in the report.
 * @property name The name of the column to group. This version supports subscription lowest possible grain.
 * @property type Has type of the column to group.
 */
public data class ReportConfigGroupingArgs(
    public val name: Output<String>,
    public val type: Output<Either<String, QueryColumnType>>,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ReportConfigGroupingArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.ReportConfigGroupingArgs =
        com.pulumi.azurenative.costmanagement.inputs.ReportConfigGroupingArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ReportConfigGroupingArgs].
 */
@PulumiTagMarker
public class ReportConfigGroupingArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<Either<String, QueryColumnType>>? = null

    /**
     * @param value The name of the column to group. This version supports subscription lowest possible grain.
     */
    @JvmName("ltsnmcqjiscurylp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Has type of the column to group.
     */
    @JvmName("rdojkgxmgojrsfry")
    public suspend fun type(`value`: Output<Either<String, QueryColumnType>>) {
        this.type = value
    }

    /**
     * @param value The name of the column to group. This version supports subscription lowest possible grain.
     */
    @JvmName("ciuxuycqdhvhellu")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Has type of the column to group.
     */
    @JvmName("aebvwdjbldeofouc")
    public suspend fun type(`value`: Either<String, QueryColumnType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Has type of the column to group.
     */
    @JvmName("itmpcrwcrppyfnkp")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, QueryColumnType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Has type of the column to group.
     */
    @JvmName("ypwdrfgqruangeyg")
    public fun type(`value`: QueryColumnType) {
        val toBeMapped = Either.ofRight<String, QueryColumnType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ReportConfigGroupingArgs = ReportConfigGroupingArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
