@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ReportConfigSortingArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.ReportConfigSortingType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The order by expression to be used in the report.
 * @property direction Direction of sort.
 * @property name The name of the column to sort.
 */
public data class ReportConfigSortingArgs(
    public val direction: Output<Either<String, ReportConfigSortingType>>? = null,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ReportConfigSortingArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.ReportConfigSortingArgs =
        com.pulumi.azurenative.costmanagement.inputs.ReportConfigSortingArgs.builder()
            .direction(
                direction?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReportConfigSortingArgs].
 */
@PulumiTagMarker
public class ReportConfigSortingArgsBuilder internal constructor() {
    private var direction: Output<Either<String, ReportConfigSortingType>>? = null

    private var name: Output<String>? = null

    /**
     * @param value Direction of sort.
     */
    @JvmName("ojqttauuslowgxpp")
    public suspend fun direction(`value`: Output<Either<String, ReportConfigSortingType>>) {
        this.direction = value
    }

    /**
     * @param value The name of the column to sort.
     */
    @JvmName("moovmrjukentqoep")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Direction of sort.
     */
    @JvmName("ockxksovwccmkmnf")
    public suspend fun direction(`value`: Either<String, ReportConfigSortingType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Direction of sort.
     */
    @JvmName("furrxbwxmjjuriyj")
    public fun direction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ReportConfigSortingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Direction of sort.
     */
    @JvmName("tcchojlwvgxpsdpd")
    public fun direction(`value`: ReportConfigSortingType) {
        val toBeMapped = Either.ofRight<String, ReportConfigSortingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value The name of the column to sort.
     */
    @JvmName("pioutnuelgfpiryi")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ReportConfigSortingArgs = ReportConfigSortingArgs(
        direction = direction,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
