@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ReportDatasetArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.GranularityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The definition of data present in the report.
 * @property aggregation Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses.
 * @property configuration Has configuration information for the data in the report. The configuration will be ignored if aggregation and grouping are provided.
 * @property filter Has filter expression to use in the report.
 * @property granularity The granularity of rows in the report.
 * @property grouping Array of group by expression to use in the report. Report can have up to 2 group by clauses.
 */
public data class ReportDatasetArgs(
    public val aggregation: Output<Map<String, ReportAggregationArgs>>? = null,
    public val configuration: Output<ReportDatasetConfigurationArgs>? = null,
    public val filter: Output<ReportFilterArgs>? = null,
    public val granularity: Output<Either<String, GranularityType>>? = null,
    public val grouping: Output<List<ReportGroupingArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ReportDatasetArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.ReportDatasetArgs =
        com.pulumi.azurenative.costmanagement.inputs.ReportDatasetArgs.builder()
            .aggregation(
                aggregation?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .filter(filter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .granularity(
                granularity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .grouping(
                grouping?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ReportDatasetArgs].
 */
@PulumiTagMarker
public class ReportDatasetArgsBuilder internal constructor() {
    private var aggregation: Output<Map<String, ReportAggregationArgs>>? = null

    private var configuration: Output<ReportDatasetConfigurationArgs>? = null

    private var filter: Output<ReportFilterArgs>? = null

    private var granularity: Output<Either<String, GranularityType>>? = null

    private var grouping: Output<List<ReportGroupingArgs>>? = null

    /**
     * @param value Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses.
     */
    @JvmName("vhtitsruaauprdch")
    public suspend fun aggregation(`value`: Output<Map<String, ReportAggregationArgs>>) {
        this.aggregation = value
    }

    /**
     * @param value Has configuration information for the data in the report. The configuration will be ignored if aggregation and grouping are provided.
     */
    @JvmName("dnmtlacushkfepta")
    public suspend fun configuration(`value`: Output<ReportDatasetConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value Has filter expression to use in the report.
     */
    @JvmName("lraaduawaxlixsgr")
    public suspend fun filter(`value`: Output<ReportFilterArgs>) {
        this.filter = value
    }

    /**
     * @param value The granularity of rows in the report.
     */
    @JvmName("dypidfwxaklwcgmq")
    public suspend fun granularity(`value`: Output<Either<String, GranularityType>>) {
        this.granularity = value
    }

    /**
     * @param value Array of group by expression to use in the report. Report can have up to 2 group by clauses.
     */
    @JvmName("noibyjmthlooulgu")
    public suspend fun grouping(`value`: Output<List<ReportGroupingArgs>>) {
        this.grouping = value
    }

    @JvmName("kyjylhuvmkapjccn")
    public suspend fun grouping(vararg values: Output<ReportGroupingArgs>) {
        this.grouping = Output.all(values.asList())
    }

    /**
     * @param values Array of group by expression to use in the report. Report can have up to 2 group by clauses.
     */
    @JvmName("lemulwuvlgrpyfgv")
    public suspend fun grouping(values: List<Output<ReportGroupingArgs>>) {
        this.grouping = Output.all(values)
    }

    /**
     * @param value Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses.
     */
    @JvmName("txvquocrhdlfgtyj")
    public suspend fun aggregation(`value`: Map<String, ReportAggregationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aggregation = mapped
    }

    /**
     * @param argument Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses.
     */
    @JvmName("brlesiqjvcvcpbbs")
    public suspend fun aggregation(
        vararg
        argument: Pair<String, suspend ReportAggregationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ReportAggregationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.aggregation = mapped
    }

    /**
     * @param values Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses.
     */
    @JvmName("ocwyobjjrqnbbecj")
    public fun aggregation(vararg values: Pair<String, ReportAggregationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aggregation = mapped
    }

    /**
     * @param value Has configuration information for the data in the report. The configuration will be ignored if aggregation and grouping are provided.
     */
    @JvmName("jsybrmgmdswbgaik")
    public suspend fun configuration(`value`: ReportDatasetConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument Has configuration information for the data in the report. The configuration will be ignored if aggregation and grouping are provided.
     */
    @JvmName("odxrospdrhfhight")
    public suspend
    fun configuration(argument: suspend ReportDatasetConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ReportDatasetConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value Has filter expression to use in the report.
     */
    @JvmName("javstmcypcjqrece")
    public suspend fun filter(`value`: ReportFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument Has filter expression to use in the report.
     */
    @JvmName("lyvjajdywxtsrfav")
    public suspend fun filter(argument: suspend ReportFilterArgsBuilder.() -> Unit) {
        val toBeMapped = ReportFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    /**
     * @param value The granularity of rows in the report.
     */
    @JvmName("isigvaiobwnbqidg")
    public suspend fun granularity(`value`: Either<String, GranularityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.granularity = mapped
    }

    /**
     * @param value The granularity of rows in the report.
     */
    @JvmName("jhdiaqdhlcmgfnjj")
    public fun granularity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GranularityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.granularity = mapped
    }

    /**
     * @param value The granularity of rows in the report.
     */
    @JvmName("pnnfavdxcsuacfll")
    public fun granularity(`value`: GranularityType) {
        val toBeMapped = Either.ofRight<String, GranularityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.granularity = mapped
    }

    /**
     * @param value Array of group by expression to use in the report. Report can have up to 2 group by clauses.
     */
    @JvmName("qnxbmuhwunrstkcy")
    public suspend fun grouping(`value`: List<ReportGroupingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grouping = mapped
    }

    /**
     * @param argument Array of group by expression to use in the report. Report can have up to 2 group by clauses.
     */
    @JvmName("tsaessoltamoliha")
    public suspend fun grouping(argument: List<suspend ReportGroupingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReportGroupingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.grouping = mapped
    }

    /**
     * @param argument Array of group by expression to use in the report. Report can have up to 2 group by clauses.
     */
    @JvmName("butaabovcosjukhg")
    public suspend fun grouping(vararg argument: suspend ReportGroupingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ReportGroupingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.grouping = mapped
    }

    /**
     * @param argument Array of group by expression to use in the report. Report can have up to 2 group by clauses.
     */
    @JvmName("gkwsfcdbbvuhxlea")
    public suspend fun grouping(argument: suspend ReportGroupingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ReportGroupingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.grouping = mapped
    }

    /**
     * @param values Array of group by expression to use in the report. Report can have up to 2 group by clauses.
     */
    @JvmName("hdariaevvbferdeo")
    public suspend fun grouping(vararg values: ReportGroupingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.grouping = mapped
    }

    internal fun build(): ReportDatasetArgs = ReportDatasetArgs(
        aggregation = aggregation,
        configuration = configuration,
        filter = filter,
        granularity = granularity,
        grouping = grouping,
    )
}
