@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.SchedulePropertiesArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.DaysOfWeek
import com.pulumi.azurenative.costmanagement.kotlin.enums.ScheduleFrequency
import com.pulumi.azurenative.costmanagement.kotlin.enums.WeeksOfMonth
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties of the schedule.
 * @property dayOfMonth UTC day on which cost analysis data will be emailed. Must be between 1 and 31. This property is applicable when frequency is Monthly and overrides weeksOfMonth or daysOfWeek.
 * @property daysOfWeek Day names in english on which cost analysis data will be emailed. This property is applicable when frequency is Weekly or Monthly.
 * @property endDate The end date and time of the scheduled action (UTC).
 * @property frequency Frequency of the schedule.
 * @property hourOfDay UTC time at which cost analysis data will be emailed.
 * @property startDate The start date and time of the scheduled action (UTC).
 * @property weeksOfMonth Weeks in which cost analysis data will be emailed. This property is applicable when frequency is Monthly and used in combination with daysOfWeek.
 */
public data class SchedulePropertiesArgs(
    public val dayOfMonth: Output<Int>? = null,
    public val daysOfWeek: Output<List<Either<String, DaysOfWeek>>>? = null,
    public val endDate: Output<String>,
    public val frequency: Output<Either<String, ScheduleFrequency>>,
    public val hourOfDay: Output<Int>? = null,
    public val startDate: Output<String>,
    public val weeksOfMonth: Output<List<Either<String, WeeksOfMonth>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.SchedulePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.SchedulePropertiesArgs =
        com.pulumi.azurenative.costmanagement.inputs.SchedulePropertiesArgs.builder()
            .dayOfMonth(dayOfMonth?.applyValue({ args0 -> args0 }))
            .daysOfWeek(
                daysOfWeek?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .endDate(endDate.applyValue({ args0 -> args0 }))
            .frequency(
                frequency.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .hourOfDay(hourOfDay?.applyValue({ args0 -> args0 }))
            .startDate(startDate.applyValue({ args0 -> args0 }))
            .weeksOfMonth(
                weeksOfMonth?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            ).build()
}

/**
 * Builder for [SchedulePropertiesArgs].
 */
@PulumiTagMarker
public class SchedulePropertiesArgsBuilder internal constructor() {
    private var dayOfMonth: Output<Int>? = null

    private var daysOfWeek: Output<List<Either<String, DaysOfWeek>>>? = null

    private var endDate: Output<String>? = null

    private var frequency: Output<Either<String, ScheduleFrequency>>? = null

    private var hourOfDay: Output<Int>? = null

    private var startDate: Output<String>? = null

    private var weeksOfMonth: Output<List<Either<String, WeeksOfMonth>>>? = null

    /**
     * @param value UTC day on which cost analysis data will be emailed. Must be between 1 and 31. This property is applicable when frequency is Monthly and overrides weeksOfMonth or daysOfWeek.
     */
    @JvmName("vyfjqbpyvbvunmyc")
    public suspend fun dayOfMonth(`value`: Output<Int>) {
        this.dayOfMonth = value
    }

    /**
     * @param value Day names in english on which cost analysis data will be emailed. This property is applicable when frequency is Weekly or Monthly.
     */
    @JvmName("glkxhtwgccitwkgv")
    public suspend fun daysOfWeek(`value`: Output<List<Either<String, DaysOfWeek>>>) {
        this.daysOfWeek = value
    }

    @JvmName("ieleibtbbqvgnugi")
    public suspend fun daysOfWeek(vararg values: Output<Either<String, DaysOfWeek>>) {
        this.daysOfWeek = Output.all(values.asList())
    }

    /**
     * @param values Day names in english on which cost analysis data will be emailed. This property is applicable when frequency is Weekly or Monthly.
     */
    @JvmName("vcmkhddbpgmjjrlk")
    public suspend fun daysOfWeek(values: List<Output<Either<String, DaysOfWeek>>>) {
        this.daysOfWeek = Output.all(values)
    }

    /**
     * @param value The end date and time of the scheduled action (UTC).
     */
    @JvmName("qarpigvysydebeqk")
    public suspend fun endDate(`value`: Output<String>) {
        this.endDate = value
    }

    /**
     * @param value Frequency of the schedule.
     */
    @JvmName("baxwskhbcisvxrfl")
    public suspend fun frequency(`value`: Output<Either<String, ScheduleFrequency>>) {
        this.frequency = value
    }

    /**
     * @param value UTC time at which cost analysis data will be emailed.
     */
    @JvmName("usncofovejvlyaey")
    public suspend fun hourOfDay(`value`: Output<Int>) {
        this.hourOfDay = value
    }

    /**
     * @param value The start date and time of the scheduled action (UTC).
     */
    @JvmName("qubikhrynuriccpl")
    public suspend fun startDate(`value`: Output<String>) {
        this.startDate = value
    }

    /**
     * @param value Weeks in which cost analysis data will be emailed. This property is applicable when frequency is Monthly and used in combination with daysOfWeek.
     */
    @JvmName("urjupxilexfpnnon")
    public suspend fun weeksOfMonth(`value`: Output<List<Either<String, WeeksOfMonth>>>) {
        this.weeksOfMonth = value
    }

    @JvmName("viuvvpeddcdnfxdx")
    public suspend fun weeksOfMonth(vararg values: Output<Either<String, WeeksOfMonth>>) {
        this.weeksOfMonth = Output.all(values.asList())
    }

    /**
     * @param values Weeks in which cost analysis data will be emailed. This property is applicable when frequency is Monthly and used in combination with daysOfWeek.
     */
    @JvmName("kawnqxptkjgwfxfn")
    public suspend fun weeksOfMonth(values: List<Output<Either<String, WeeksOfMonth>>>) {
        this.weeksOfMonth = Output.all(values)
    }

    /**
     * @param value UTC day on which cost analysis data will be emailed. Must be between 1 and 31. This property is applicable when frequency is Monthly and overrides weeksOfMonth or daysOfWeek.
     */
    @JvmName("ywjgmommeuuffson")
    public suspend fun dayOfMonth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dayOfMonth = mapped
    }

    /**
     * @param value Day names in english on which cost analysis data will be emailed. This property is applicable when frequency is Weekly or Monthly.
     */
    @JvmName("voersvkxxceuhqjf")
    public suspend fun daysOfWeek(`value`: List<Either<String, DaysOfWeek>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daysOfWeek = mapped
    }

    /**
     * @param values Day names in english on which cost analysis data will be emailed. This property is applicable when frequency is Weekly or Monthly.
     */
    @JvmName("eicauxmspdmsqext")
    public suspend fun daysOfWeek(vararg values: Either<String, DaysOfWeek>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.daysOfWeek = mapped
    }

    /**
     * @param value The end date and time of the scheduled action (UTC).
     */
    @JvmName("kgppppltkqjksjgd")
    public suspend fun endDate(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endDate = mapped
    }

    /**
     * @param value Frequency of the schedule.
     */
    @JvmName("uhiscxeoywlbpggv")
    public suspend fun frequency(`value`: Either<String, ScheduleFrequency>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value Frequency of the schedule.
     */
    @JvmName("vrphvnwfqjqygsbi")
    public fun frequency(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScheduleFrequency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value Frequency of the schedule.
     */
    @JvmName("laonvydcnyqtaheb")
    public fun frequency(`value`: ScheduleFrequency) {
        val toBeMapped = Either.ofRight<String, ScheduleFrequency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value UTC time at which cost analysis data will be emailed.
     */
    @JvmName("pxdbfavwuvqplebs")
    public suspend fun hourOfDay(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hourOfDay = mapped
    }

    /**
     * @param value The start date and time of the scheduled action (UTC).
     */
    @JvmName("udfirtvhwggiybnx")
    public suspend fun startDate(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startDate = mapped
    }

    /**
     * @param value Weeks in which cost analysis data will be emailed. This property is applicable when frequency is Monthly and used in combination with daysOfWeek.
     */
    @JvmName("xiilwcarbvegigtr")
    public suspend fun weeksOfMonth(`value`: List<Either<String, WeeksOfMonth>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weeksOfMonth = mapped
    }

    /**
     * @param values Weeks in which cost analysis data will be emailed. This property is applicable when frequency is Monthly and used in combination with daysOfWeek.
     */
    @JvmName("ysivsjlwycehgsuh")
    public suspend fun weeksOfMonth(vararg values: Either<String, WeeksOfMonth>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weeksOfMonth = mapped
    }

    internal fun build(): SchedulePropertiesArgs = SchedulePropertiesArgs(
        dayOfMonth = dayOfMonth,
        daysOfWeek = daysOfWeek,
        endDate = endDate ?: throw PulumiNullFieldException("endDate"),
        frequency = frequency ?: throw PulumiNullFieldException("frequency"),
        hourOfDay = hourOfDay,
        startDate = startDate ?: throw PulumiNullFieldException("startDate"),
        weeksOfMonth = weeksOfMonth,
    )
}
