@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.TargetCostAllocationResourceArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.CostAllocationPolicyType
import com.pulumi.azurenative.costmanagement.kotlin.enums.CostAllocationResourceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Target resources for cost allocation.
 * @property name If resource type is dimension, this must be either ResourceGroupName or SubscriptionId. If resource type is tag, this must be a valid Azure tag
 * @property policyType Method of cost allocation for the rule
 * @property resourceType Type of resources contained in this cost allocation rule
 * @property values Target resources for cost allocation. This list cannot contain more than 25 values.
 */
public data class TargetCostAllocationResourceArgs(
    public val name: Output<String>,
    public val policyType: Output<Either<String, CostAllocationPolicyType>>,
    public val resourceType: Output<Either<String, CostAllocationResourceType>>,
    public val values: Output<List<CostAllocationProportionArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.TargetCostAllocationResourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.costmanagement.inputs.TargetCostAllocationResourceArgs =
        com.pulumi.azurenative.costmanagement.inputs.TargetCostAllocationResourceArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .policyType(
                policyType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceType(
                resourceType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .values(
                values.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TargetCostAllocationResourceArgs].
 */
@PulumiTagMarker
public class TargetCostAllocationResourceArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var policyType: Output<Either<String, CostAllocationPolicyType>>? = null

    private var resourceType: Output<Either<String, CostAllocationResourceType>>? = null

    private var values: Output<List<CostAllocationProportionArgs>>? = null

    /**
     * @param value If resource type is dimension, this must be either ResourceGroupName or SubscriptionId. If resource type is tag, this must be a valid Azure tag
     */
    @JvmName("burhethshvwrjysi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Method of cost allocation for the rule
     */
    @JvmName("utjimixxskdteprq")
    public suspend fun policyType(`value`: Output<Either<String, CostAllocationPolicyType>>) {
        this.policyType = value
    }

    /**
     * @param value Type of resources contained in this cost allocation rule
     */
    @JvmName("nqwdmavvcwjjjtsx")
    public suspend fun resourceType(`value`: Output<Either<String, CostAllocationResourceType>>) {
        this.resourceType = value
    }

    /**
     * @param value Target resources for cost allocation. This list cannot contain more than 25 values.
     */
    @JvmName("abcpkrbirpmacokn")
    public suspend fun values(`value`: Output<List<CostAllocationProportionArgs>>) {
        this.values = value
    }

    @JvmName("fcymrsnyjstitmel")
    public suspend fun values(vararg values: Output<CostAllocationProportionArgs>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values Target resources for cost allocation. This list cannot contain more than 25 values.
     */
    @JvmName("ctdvsspbpbwwwnih")
    public suspend fun values(values: List<Output<CostAllocationProportionArgs>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value If resource type is dimension, this must be either ResourceGroupName or SubscriptionId. If resource type is tag, this must be a valid Azure tag
     */
    @JvmName("tlvedoivmstwbflv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Method of cost allocation for the rule
     */
    @JvmName("xjjrohlugbiulcbv")
    public suspend fun policyType(`value`: Either<String, CostAllocationPolicyType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value Method of cost allocation for the rule
     */
    @JvmName("ltfpboawiodqkbwq")
    public fun policyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CostAllocationPolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value Method of cost allocation for the rule
     */
    @JvmName("gfsitfjagarmorld")
    public fun policyType(`value`: CostAllocationPolicyType) {
        val toBeMapped = Either.ofRight<String, CostAllocationPolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value Type of resources contained in this cost allocation rule
     */
    @JvmName("mvrrfsgukdaefbtg")
    public suspend fun resourceType(`value`: Either<String, CostAllocationResourceType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Type of resources contained in this cost allocation rule
     */
    @JvmName("bgeaaroeaorvsxxx")
    public fun resourceType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CostAllocationResourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Type of resources contained in this cost allocation rule
     */
    @JvmName("sdwxysbwhwlcokmb")
    public fun resourceType(`value`: CostAllocationResourceType) {
        val toBeMapped = Either.ofRight<String, CostAllocationResourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Target resources for cost allocation. This list cannot contain more than 25 values.
     */
    @JvmName("jogukeqckdqqpoej")
    public suspend fun values(`value`: List<CostAllocationProportionArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param argument Target resources for cost allocation. This list cannot contain more than 25 values.
     */
    @JvmName("ykjkamquwtpaxefw")
    public suspend
    fun values(argument: List<suspend CostAllocationProportionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CostAllocationProportionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param argument Target resources for cost allocation. This list cannot contain more than 25 values.
     */
    @JvmName("rcbkcxpaaehncyvv")
    public suspend fun values(
        vararg
        argument: suspend CostAllocationProportionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CostAllocationProportionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param argument Target resources for cost allocation. This list cannot contain more than 25 values.
     */
    @JvmName("vslmldjicjduuxfg")
    public suspend fun values(argument: suspend CostAllocationProportionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CostAllocationProportionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param values Target resources for cost allocation. This list cannot contain more than 25 values.
     */
    @JvmName("hwrlbqdigfrosfbg")
    public suspend fun values(vararg values: CostAllocationProportionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): TargetCostAllocationResourceArgs = TargetCostAllocationResourceArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        policyType = policyType ?: throw PulumiNullFieldException("policyType"),
        resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
