@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The common properties of the export.
 * @property definition Has the definition for the export.
 * @property deliveryInfo Has delivery information for the export.
 * @property format The format of the export being delivered. Currently only 'Csv' is supported.
 * @property nextRunTimeEstimate If the export has an active schedule, provides an estimate of the next run time.
 * @property partitionData If set to true, exported data will be partitioned by size and placed in a blob directory together with a manifest file. Note: this option is currently available only for Microsoft Customer Agreement commerce scopes.
 * @property runHistory If requested, has the most recent run history for the export.
 */
public data class CommonExportPropertiesResponse(
    public val definition: ExportDefinitionResponse,
    public val deliveryInfo: ExportDeliveryInfoResponse,
    public val format: String? = null,
    public val nextRunTimeEstimate: String,
    public val partitionData: Boolean? = null,
    public val runHistory: ExportExecutionListResultResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.CommonExportPropertiesResponse):
            CommonExportPropertiesResponse = CommonExportPropertiesResponse(
            definition = javaType.definition().let({ args0 ->
                com.pulumi.azurenative.costmanagement.kotlin.outputs.ExportDefinitionResponse.Companion.toKotlin(args0)
            }),
            deliveryInfo = javaType.deliveryInfo().let({ args0 ->
                com.pulumi.azurenative.costmanagement.kotlin.outputs.ExportDeliveryInfoResponse.Companion.toKotlin(args0)
            }),
            format = javaType.format().map({ args0 -> args0 }).orElse(null),
            nextRunTimeEstimate = javaType.nextRunTimeEstimate(),
            partitionData = javaType.partitionData().map({ args0 -> args0 }).orElse(null),
            runHistory = javaType.runHistory().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ExportExecutionListResultResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
