@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Collection and ingestion information
 * @property error Error information of last collection
 * @property lastChecked Last time the data acquisition process initiated connecting to the external provider
 * @property lastRun Last time the data acquisition process completed (even if no new data was found)
 * @property lastUpdated Last time the external data was updated into Azure
 * @property sourceLastUpdated Source timestamp of external data currently available in Azure (eg AWS last processed CUR file timestamp)
 */
public data class ConnectorCollectionInfoResponse(
    public val error: ConnectorCollectionErrorInfoResponse? = null,
    public val lastChecked: String? = null,
    public val lastRun: String,
    public val lastUpdated: String,
    public val sourceLastUpdated: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.ConnectorCollectionInfoResponse):
            ConnectorCollectionInfoResponse = ConnectorCollectionInfoResponse(
            error = javaType.error().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ConnectorCollectionErrorInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lastChecked = javaType.lastChecked().map({ args0 -> args0 }).orElse(null),
            lastRun = javaType.lastRun(),
            lastUpdated = javaType.lastUpdated(),
            sourceLastUpdated = javaType.sourceLastUpdated(),
        )
    }
}
