@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The cost allocation rule model definition
 * @property id Azure Resource Manager Id for the rule. This is a read ony value.
 * @property name Name of the rule. This is a read only value.
 * @property properties Cost allocation rule properties
 * @property type Resource type of the rule. This is a read only value of Microsoft.CostManagement/CostAllocationRule.
 */
public data class GetCostAllocationRuleResult(
    public val id: String,
    public val name: String,
    public val properties: CostAllocationRulePropertiesResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.GetCostAllocationRuleResult):
            GetCostAllocationRuleResult = GetCostAllocationRuleResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.costmanagement.kotlin.outputs.CostAllocationRulePropertiesResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
