@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A report resource.
 * @property definition Has definition for the report.
 * @property deliveryInfo Has delivery information for the report.
 * @property format The format of the report being delivered.
 * @property id Resource Id.
 * @property name Resource name.
 * @property schedule Has schedule information for the report.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetReportByResourceGroupNameResult(
    public val definition: ReportDefinitionResponse,
    public val deliveryInfo: ReportDeliveryInfoResponse,
    public val format: String? = null,
    public val id: String,
    public val name: String,
    public val schedule: ReportScheduleResponse? = null,
    public val tags: Map<String, String>,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.GetReportByResourceGroupNameResult):
            GetReportByResourceGroupNameResult = GetReportByResourceGroupNameResult(
            definition = javaType.definition().let({ args0 ->
                com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportDefinitionResponse.Companion.toKotlin(args0)
            }),
            deliveryInfo = javaType.deliveryInfo().let({ args0 ->
                com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportDeliveryInfoResponse.Companion.toKotlin(args0)
            }),
            format = javaType.format().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            schedule = javaType.schedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportScheduleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
