@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The notification associated with a budget.
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 * @property contactEmails Email addresses to send the notification to when the threshold is breached. Must have at least one contact email or contact group specified at the Subscription or Resource Group scopes. All other scopes must have at least one contact email specified.
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 * @property contactGroups Subscription or Resource Group scopes only. Action groups to send the notification to when the threshold is exceeded. Must be provided as a fully qualified Azure resource id.
 *  Supported for CategoryType(s): Cost.
 * @property contactRoles Subscription or Resource Group scopes only. Contact roles to send the notification to when the threshold is breached.
 *  Supported for CategoryType(s): Cost.
 * @property enabled The notification is enabled or not.
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 * @property frequency Frequency of a notification. Represents how long the notification will be silent after triggering an alert for a threshold breach. If not specified, the frequency will be set by default based on the timeGrain (Weekly when timeGrain: Last7Days, Monthly when timeGrain: Last30Days).
 *  Supported for CategoryType(s): ReservationUtilization.
 * @property locale Language in which the recipient will receive the notification,
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 * @property operator The comparison operator.
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 *  Supported operators for **CategoryType: Cost**
 * - GreaterThan
 * - GreaterThanOrEqualTo
 *  Supported operators for **CategoryType: ReservationUtilization**
 * - LessThan
 * @property threshold Threshold value associated with a notification. It is always percent with a maximum of 2 decimal places.
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 *  **CategoryType: Cost** - Must be between 0 and 1000. Notification is sent when the cost exceeded the threshold.
 *  **CategoryType: ReservationUtilization** - Must be between 0 and 100. Notification is sent when a reservation has a utilization percentage below the threshold.
 * @property thresholdType The type of threshold.
 *  Supported for CategoryType(s): Cost.
 */
public data class NotificationResponse(
    public val contactEmails: List<String>,
    public val contactGroups: List<String>? = null,
    public val contactRoles: List<String>? = null,
    public val enabled: Boolean,
    public val frequency: String? = null,
    public val locale: String? = null,
    public val `operator`: String,
    public val threshold: Double,
    public val thresholdType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.NotificationResponse):
            NotificationResponse = NotificationResponse(
            contactEmails = javaType.contactEmails().map({ args0 -> args0 }),
            contactGroups = javaType.contactGroups().map({ args0 -> args0 }),
            contactRoles = javaType.contactRoles().map({ args0 -> args0 }),
            enabled = javaType.enabled(),
            frequency = javaType.frequency().map({ args0 -> args0 }).orElse(null),
            locale = javaType.locale().map({ args0 -> args0 }).orElse(null),
            `operator` = javaType.`operator`(),
            threshold = javaType.threshold(),
            thresholdType = javaType.thresholdType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
