@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Connector].
 */
@PulumiTagMarker
public class ConnectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectorArgs = ConnectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectorArgsBuilder.() -> Unit) {
        val builder = ConnectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Connector {
        val builtJavaResource =
            com.pulumi.azurenative.customerinsights.Connector(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Connector(builtJavaResource)
    }
}

/**
 * The connector resource format.
 * Azure REST API version: 2017-04-26. Prior API version in Azure Native 1.x: 2017-04-26.
 * ## Example Usage
 * ### Connectors_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connector = new AzureNative.CustomerInsights.Connector("connector", new()
 *     {
 *         ConnectorName = "testConnector",
 *         ConnectorProperties =
 *         {
 *             { "connectionKeyVaultUrl",
 *             {
 *                 { "organizationId", "XXX" },
 *                 { "organizationUrl", "https://XXX.crmlivetie.com/" },
 *             } },
 *         },
 *         ConnectorType = "AzureBlob",
 *         Description = "Test connector",
 *         DisplayName = "testConnector",
 *         HubName = "sdkTestHub",
 *         ResourceGroupName = "TestHubRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customerinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customerinsights.NewConnector(ctx, "connector", &customerinsights.ConnectorArgs{
 * 			ConnectorName: pulumi.String("testConnector"),
 * 			ConnectorProperties: pulumi.Map{
 * 				"connectionKeyVaultUrl": pulumi.Any{
 * 					OrganizationId:  "XXX",
 * 					OrganizationUrl: "https://XXX.crmlivetie.com/",
 * 				},
 * 			},
 * 			ConnectorType:     pulumi.String("AzureBlob"),
 * 			Description:       pulumi.String("Test connector"),
 * 			DisplayName:       pulumi.String("testConnector"),
 * 			HubName:           pulumi.String("sdkTestHub"),
 * 			ResourceGroupName: pulumi.String("TestHubRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customerinsights.Connector;
 * import com.pulumi.azurenative.customerinsights.ConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connector = new Connector("connector", ConnectorArgs.builder()
 *             .connectorName("testConnector")
 *             .connectorProperties(Map.of("connectionKeyVaultUrl", Map.ofEntries(
 *                 Map.entry("organizationId", "XXX"),
 *                 Map.entry("organizationUrl", "https://XXX.crmlivetie.com/")
 *             )))
 *             .connectorType("AzureBlob")
 *             .description("Test connector")
 *             .displayName("testConnector")
 *             .hubName("sdkTestHub")
 *             .resourceGroupName("TestHubRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customerinsights:Connector sdkTestHub/testConnector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/connectors/{connectorName}
 * ```
 */
public class Connector internal constructor(
    override val javaResource: com.pulumi.azurenative.customerinsights.Connector,
) : KotlinCustomResource(javaResource, ConnectorMapper) {
    /**
     * ID of the connector.
     */
    public val connectorId: Output<Int>
        get() = javaResource.connectorId().applyValue({ args0 -> args0 })

    /**
     * Name of the connector.
     */
    public val connectorName: Output<String>?
        get() = javaResource.connectorName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The connector properties.
     */
    public val connectorProperties: Output<Map<String, Any>>
        get() = javaResource.connectorProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Type of connector.
     */
    public val connectorType: Output<String>
        get() = javaResource.connectorType().applyValue({ args0 -> args0 })

    /**
     * The created time.
     */
    public val created: Output<String>
        get() = javaResource.created().applyValue({ args0 -> args0 })

    /**
     * Description of the connector.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Display name of the connector.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If this is an internal connector.
     */
    public val isInternal: Output<Boolean>?
        get() = javaResource.isInternal().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The last modified time.
     */
    public val lastModified: Output<String>
        get() = javaResource.lastModified().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * State of connector.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The hub name.
     */
    public val tenantId: Output<String>
        get() = javaResource.tenantId().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConnectorMapper : ResourceMapper<Connector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.customerinsights.Connector::class == javaResource::class

    override fun map(javaResource: Resource): Connector = Connector(
        javaResource as
            com.pulumi.azurenative.customerinsights.Connector,
    )
}

/**
 * @see [Connector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Connector].
 */
public suspend fun connector(name: String, block: suspend ConnectorResourceBuilder.() -> Unit):
    Connector {
    val builder = ConnectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Connector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connector(name: String): Connector {
    val builder = ConnectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
