@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin

import com.pulumi.azurenative.customerinsights.CustomerinsightsFunctions.getConnectorMappingPlain
import com.pulumi.azurenative.customerinsights.CustomerinsightsFunctions.getConnectorPlain
import com.pulumi.azurenative.customerinsights.CustomerinsightsFunctions.getHubPlain
import com.pulumi.azurenative.customerinsights.CustomerinsightsFunctions.getImageUploadUrlForDataPlain
import com.pulumi.azurenative.customerinsights.CustomerinsightsFunctions.getImageUploadUrlForEntityTypePlain
import com.pulumi.azurenative.customerinsights.CustomerinsightsFunctions.getKpiPlain
import com.pulumi.azurenative.customerinsights.CustomerinsightsFunctions.getLinkPlain
import com.pulumi.azurenative.customerinsights.CustomerinsightsFunctions.getPredictionModelStatusPlain
import com.pulumi.azurenative.customerinsights.CustomerinsightsFunctions.getPredictionPlain
import com.pulumi.azurenative.customerinsights.CustomerinsightsFunctions.getPredictionTrainingResultsPlain
import com.pulumi.azurenative.customerinsights.CustomerinsightsFunctions.getProfilePlain
import com.pulumi.azurenative.customerinsights.CustomerinsightsFunctions.getRelationshipLinkPlain
import com.pulumi.azurenative.customerinsights.CustomerinsightsFunctions.getRelationshipPlain
import com.pulumi.azurenative.customerinsights.CustomerinsightsFunctions.getRoleAssignmentPlain
import com.pulumi.azurenative.customerinsights.CustomerinsightsFunctions.getViewPlain
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetConnectorMappingPlainArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetConnectorMappingPlainArgsBuilder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetConnectorPlainArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetConnectorPlainArgsBuilder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetHubPlainArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetHubPlainArgsBuilder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetImageUploadUrlForDataPlainArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetImageUploadUrlForDataPlainArgsBuilder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetImageUploadUrlForEntityTypePlainArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetImageUploadUrlForEntityTypePlainArgsBuilder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetKpiPlainArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetKpiPlainArgsBuilder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetLinkPlainArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetLinkPlainArgsBuilder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetPredictionModelStatusPlainArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetPredictionModelStatusPlainArgsBuilder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetPredictionPlainArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetPredictionPlainArgsBuilder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetPredictionTrainingResultsPlainArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetPredictionTrainingResultsPlainArgsBuilder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetProfilePlainArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetProfilePlainArgsBuilder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetRelationshipLinkPlainArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetRelationshipLinkPlainArgsBuilder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetRelationshipPlainArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetRelationshipPlainArgsBuilder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetRoleAssignmentPlainArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetRoleAssignmentPlainArgsBuilder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetViewPlainArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.GetViewPlainArgsBuilder
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetConnectorMappingResult
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetConnectorResult
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetHubResult
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetImageUploadUrlForDataResult
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetImageUploadUrlForEntityTypeResult
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetKpiResult
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetLinkResult
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetPredictionModelStatusResult
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetPredictionResult
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetPredictionTrainingResultsResult
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetProfileResult
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetRelationshipLinkResult
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetRelationshipResult
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetRoleAssignmentResult
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetViewResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetConnectorMappingResult.Companion.toKotlin as getConnectorMappingResultToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetConnectorResult.Companion.toKotlin as getConnectorResultToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetHubResult.Companion.toKotlin as getHubResultToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetImageUploadUrlForDataResult.Companion.toKotlin as getImageUploadUrlForDataResultToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetImageUploadUrlForEntityTypeResult.Companion.toKotlin as getImageUploadUrlForEntityTypeResultToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetKpiResult.Companion.toKotlin as getKpiResultToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetLinkResult.Companion.toKotlin as getLinkResultToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetPredictionModelStatusResult.Companion.toKotlin as getPredictionModelStatusResultToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetPredictionResult.Companion.toKotlin as getPredictionResultToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetPredictionTrainingResultsResult.Companion.toKotlin as getPredictionTrainingResultsResultToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetProfileResult.Companion.toKotlin as getProfileResultToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetRelationshipLinkResult.Companion.toKotlin as getRelationshipLinkResultToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetRelationshipResult.Companion.toKotlin as getRelationshipResultToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetRoleAssignmentResult.Companion.toKotlin as getRoleAssignmentResultToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.GetViewResult.Companion.toKotlin as getViewResultToKotlin

public object CustomerinsightsFunctions {
    /**
     * Gets a connector in the hub.
     * Azure REST API version: 2017-04-26.
     * @param argument null
     * @return The connector resource format.
     */
    public suspend fun getConnector(argument: GetConnectorPlainArgs): GetConnectorResult =
        getConnectorResultToKotlin(getConnectorPlain(argument.toJava()).await())

    /**
     * @see [getConnector].
     * @param connectorName The name of the connector.
     * @param hubName The name of the hub.
     * @param resourceGroupName The name of the resource group.
     * @return The connector resource format.
     */
    public suspend fun getConnector(
        connectorName: String,
        hubName: String,
        resourceGroupName: String,
    ): GetConnectorResult {
        val argument = GetConnectorPlainArgs(
            connectorName = connectorName,
            hubName = hubName,
            resourceGroupName = resourceGroupName,
        )
        return getConnectorResultToKotlin(getConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;customerinsights&#46;kotlin&#46;inputs&#46;GetConnectorPlainArgs].
     * @return The connector resource format.
     */
    public suspend fun getConnector(argument: suspend GetConnectorPlainArgsBuilder.() -> Unit):
        GetConnectorResult {
        val builder = GetConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectorResultToKotlin(getConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a connector mapping in the connector.
     * Azure REST API version: 2017-04-26.
     * @param argument null
     * @return The connector mapping resource format.
     */
    public suspend fun getConnectorMapping(argument: GetConnectorMappingPlainArgs):
        GetConnectorMappingResult =
        getConnectorMappingResultToKotlin(getConnectorMappingPlain(argument.toJava()).await())

    /**
     * @see [getConnectorMapping].
     * @param connectorName The name of the connector.
     * @param hubName The name of the hub.
     * @param mappingName The name of the connector mapping.
     * @param resourceGroupName The name of the resource group.
     * @return The connector mapping resource format.
     */
    public suspend fun getConnectorMapping(
        connectorName: String,
        hubName: String,
        mappingName: String,
        resourceGroupName: String,
    ): GetConnectorMappingResult {
        val argument = GetConnectorMappingPlainArgs(
            connectorName = connectorName,
            hubName = hubName,
            mappingName = mappingName,
            resourceGroupName = resourceGroupName,
        )
        return getConnectorMappingResultToKotlin(getConnectorMappingPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnectorMapping].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;customerinsights&#46;kotlin&#46;inputs&#46;GetConnectorMappingPlainArgs].
     * @return The connector mapping resource format.
     */
    public suspend
    fun getConnectorMapping(argument: suspend GetConnectorMappingPlainArgsBuilder.() -> Unit):
        GetConnectorMappingResult {
        val builder = GetConnectorMappingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectorMappingResultToKotlin(getConnectorMappingPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified hub.
     * Azure REST API version: 2017-04-26.
     * @param argument null
     * @return Hub resource.
     */
    public suspend fun getHub(argument: GetHubPlainArgs): GetHubResult =
        getHubResultToKotlin(getHubPlain(argument.toJava()).await())

    /**
     * @see [getHub].
     * @param hubName The name of the hub.
     * @param resourceGroupName The name of the resource group.
     * @return Hub resource.
     */
    public suspend fun getHub(hubName: String, resourceGroupName: String): GetHubResult {
        val argument = GetHubPlainArgs(
            hubName = hubName,
            resourceGroupName = resourceGroupName,
        )
        return getHubResultToKotlin(getHubPlain(argument.toJava()).await())
    }

    /**
     * @see [getHub].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;customerinsights&#46;kotlin&#46;inputs&#46;GetHubPlainArgs].
     * @return Hub resource.
     */
    public suspend fun getHub(argument: suspend GetHubPlainArgsBuilder.() -> Unit): GetHubResult {
        val builder = GetHubPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHubResultToKotlin(getHubPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets data image upload URL.
     * Azure REST API version: 2017-04-26.
     * @param argument null
     * @return The image definition.
     */
    public suspend fun getImageUploadUrlForData(argument: GetImageUploadUrlForDataPlainArgs):
        GetImageUploadUrlForDataResult =
        getImageUploadUrlForDataResultToKotlin(getImageUploadUrlForDataPlain(argument.toJava()).await())

    /**
     * @see [getImageUploadUrlForData].
     * @param entityType Type of entity. Can be Profile or Interaction.
     * @param entityTypeName Name of the entity type.
     * @param hubName The name of the hub.
     * @param relativePath Relative path of the image.
     * @param resourceGroupName The name of the resource group.
     * @return The image definition.
     */
    public suspend fun getImageUploadUrlForData(
        entityType: String? = null,
        entityTypeName: String? = null,
        hubName: String,
        relativePath: String? = null,
        resourceGroupName: String,
    ): GetImageUploadUrlForDataResult {
        val argument = GetImageUploadUrlForDataPlainArgs(
            entityType = entityType,
            entityTypeName = entityTypeName,
            hubName = hubName,
            relativePath = relativePath,
            resourceGroupName = resourceGroupName,
        )
        return getImageUploadUrlForDataResultToKotlin(getImageUploadUrlForDataPlain(argument.toJava()).await())
    }

    /**
     * @see [getImageUploadUrlForData].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;customerinsights&#46;kotlin&#46;inputs&#46;GetImageUploadUrlForDataPlainArgs].
     * @return The image definition.
     */
    public suspend
    fun getImageUploadUrlForData(argument: suspend GetImageUploadUrlForDataPlainArgsBuilder.() -> Unit):
        GetImageUploadUrlForDataResult {
        val builder = GetImageUploadUrlForDataPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getImageUploadUrlForDataResultToKotlin(getImageUploadUrlForDataPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets entity type (profile or interaction) image upload URL.
     * Azure REST API version: 2017-04-26.
     * @param argument null
     * @return The image definition.
     */
    public suspend
    fun getImageUploadUrlForEntityType(argument: GetImageUploadUrlForEntityTypePlainArgs):
        GetImageUploadUrlForEntityTypeResult =
        getImageUploadUrlForEntityTypeResultToKotlin(getImageUploadUrlForEntityTypePlain(argument.toJava()).await())

    /**
     * @see [getImageUploadUrlForEntityType].
     * @param entityType Type of entity. Can be Profile or Interaction.
     * @param entityTypeName Name of the entity type.
     * @param hubName The name of the hub.
     * @param relativePath Relative path of the image.
     * @param resourceGroupName The name of the resource group.
     * @return The image definition.
     */
    public suspend fun getImageUploadUrlForEntityType(
        entityType: String? = null,
        entityTypeName: String? = null,
        hubName: String,
        relativePath: String? = null,
        resourceGroupName: String,
    ): GetImageUploadUrlForEntityTypeResult {
        val argument = GetImageUploadUrlForEntityTypePlainArgs(
            entityType = entityType,
            entityTypeName = entityTypeName,
            hubName = hubName,
            relativePath = relativePath,
            resourceGroupName = resourceGroupName,
        )
        return getImageUploadUrlForEntityTypeResultToKotlin(getImageUploadUrlForEntityTypePlain(argument.toJava()).await())
    }

    /**
     * @see [getImageUploadUrlForEntityType].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;customerinsights&#46;kotlin&#46;inputs&#46;GetImageUploadUrlForEntityTypePlainArgs].
     * @return The image definition.
     */
    public suspend
    fun getImageUploadUrlForEntityType(argument: suspend GetImageUploadUrlForEntityTypePlainArgsBuilder.() -> Unit):
        GetImageUploadUrlForEntityTypeResult {
        val builder = GetImageUploadUrlForEntityTypePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getImageUploadUrlForEntityTypeResultToKotlin(getImageUploadUrlForEntityTypePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a KPI in the hub.
     * Azure REST API version: 2017-04-26.
     * @param argument null
     * @return The KPI resource format.
     */
    public suspend fun getKpi(argument: GetKpiPlainArgs): GetKpiResult =
        getKpiResultToKotlin(getKpiPlain(argument.toJava()).await())

    /**
     * @see [getKpi].
     * @param hubName The name of the hub.
     * @param kpiName The name of the KPI.
     * @param resourceGroupName The name of the resource group.
     * @return The KPI resource format.
     */
    public suspend fun getKpi(
        hubName: String,
        kpiName: String,
        resourceGroupName: String,
    ): GetKpiResult {
        val argument = GetKpiPlainArgs(
            hubName = hubName,
            kpiName = kpiName,
            resourceGroupName = resourceGroupName,
        )
        return getKpiResultToKotlin(getKpiPlain(argument.toJava()).await())
    }

    /**
     * @see [getKpi].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;customerinsights&#46;kotlin&#46;inputs&#46;GetKpiPlainArgs].
     * @return The KPI resource format.
     */
    public suspend fun getKpi(argument: suspend GetKpiPlainArgsBuilder.() -> Unit): GetKpiResult {
        val builder = GetKpiPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKpiResultToKotlin(getKpiPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a link in the hub.
     * Azure REST API version: 2017-04-26.
     * Other available API versions: 2017-01-01.
     * @param argument null
     * @return The link resource format.
     */
    public suspend fun getLink(argument: GetLinkPlainArgs): GetLinkResult =
        getLinkResultToKotlin(getLinkPlain(argument.toJava()).await())

    /**
     * @see [getLink].
     * @param hubName The name of the hub.
     * @param linkName The name of the link.
     * @param resourceGroupName The name of the resource group.
     * @return The link resource format.
     */
    public suspend fun getLink(
        hubName: String,
        linkName: String,
        resourceGroupName: String,
    ): GetLinkResult {
        val argument = GetLinkPlainArgs(
            hubName = hubName,
            linkName = linkName,
            resourceGroupName = resourceGroupName,
        )
        return getLinkResultToKotlin(getLinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getLink].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;customerinsights&#46;kotlin&#46;inputs&#46;GetLinkPlainArgs].
     * @return The link resource format.
     */
    public suspend fun getLink(argument: suspend GetLinkPlainArgsBuilder.() -> Unit): GetLinkResult {
        val builder = GetLinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLinkResultToKotlin(getLinkPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Prediction in the hub.
     * Azure REST API version: 2017-04-26.
     * @param argument null
     * @return The prediction resource format.
     */
    public suspend fun getPrediction(argument: GetPredictionPlainArgs): GetPredictionResult =
        getPredictionResultToKotlin(getPredictionPlain(argument.toJava()).await())

    /**
     * @see [getPrediction].
     * @param hubName The name of the hub.
     * @param predictionName The name of the Prediction.
     * @param resourceGroupName The name of the resource group.
     * @return The prediction resource format.
     */
    public suspend fun getPrediction(
        hubName: String,
        predictionName: String,
        resourceGroupName: String,
    ): GetPredictionResult {
        val argument = GetPredictionPlainArgs(
            hubName = hubName,
            predictionName = predictionName,
            resourceGroupName = resourceGroupName,
        )
        return getPredictionResultToKotlin(getPredictionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrediction].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;customerinsights&#46;kotlin&#46;inputs&#46;GetPredictionPlainArgs].
     * @return The prediction resource format.
     */
    public suspend fun getPrediction(argument: suspend GetPredictionPlainArgsBuilder.() -> Unit):
        GetPredictionResult {
        val builder = GetPredictionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPredictionResultToKotlin(getPredictionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets model status of the prediction.
     * Azure REST API version: 2017-04-26.
     * @param argument null
     * @return The prediction model status.
     */
    public suspend fun getPredictionModelStatus(argument: GetPredictionModelStatusPlainArgs):
        GetPredictionModelStatusResult =
        getPredictionModelStatusResultToKotlin(getPredictionModelStatusPlain(argument.toJava()).await())

    /**
     * @see [getPredictionModelStatus].
     * @param hubName The name of the hub.
     * @param predictionName The name of the Prediction.
     * @param resourceGroupName The name of the resource group.
     * @return The prediction model status.
     */
    public suspend fun getPredictionModelStatus(
        hubName: String,
        predictionName: String,
        resourceGroupName: String,
    ): GetPredictionModelStatusResult {
        val argument = GetPredictionModelStatusPlainArgs(
            hubName = hubName,
            predictionName = predictionName,
            resourceGroupName = resourceGroupName,
        )
        return getPredictionModelStatusResultToKotlin(getPredictionModelStatusPlain(argument.toJava()).await())
    }

    /**
     * @see [getPredictionModelStatus].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;customerinsights&#46;kotlin&#46;inputs&#46;GetPredictionModelStatusPlainArgs].
     * @return The prediction model status.
     */
    public suspend
    fun getPredictionModelStatus(argument: suspend GetPredictionModelStatusPlainArgsBuilder.() -> Unit):
        GetPredictionModelStatusResult {
        val builder = GetPredictionModelStatusPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPredictionModelStatusResultToKotlin(getPredictionModelStatusPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets training results.
     * Azure REST API version: 2017-04-26.
     * @param argument null
     * @return The training results of the prediction.
     */
    public suspend fun getPredictionTrainingResults(argument: GetPredictionTrainingResultsPlainArgs):
        GetPredictionTrainingResultsResult =
        getPredictionTrainingResultsResultToKotlin(getPredictionTrainingResultsPlain(argument.toJava()).await())

    /**
     * @see [getPredictionTrainingResults].
     * @param hubName The name of the hub.
     * @param predictionName The name of the Prediction.
     * @param resourceGroupName The name of the resource group.
     * @return The training results of the prediction.
     */
    public suspend fun getPredictionTrainingResults(
        hubName: String,
        predictionName: String,
        resourceGroupName: String,
    ): GetPredictionTrainingResultsResult {
        val argument = GetPredictionTrainingResultsPlainArgs(
            hubName = hubName,
            predictionName = predictionName,
            resourceGroupName = resourceGroupName,
        )
        return getPredictionTrainingResultsResultToKotlin(getPredictionTrainingResultsPlain(argument.toJava()).await())
    }

    /**
     * @see [getPredictionTrainingResults].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;customerinsights&#46;kotlin&#46;inputs&#46;GetPredictionTrainingResultsPlainArgs].
     * @return The training results of the prediction.
     */
    public suspend
    fun getPredictionTrainingResults(argument: suspend GetPredictionTrainingResultsPlainArgsBuilder.() -> Unit):
        GetPredictionTrainingResultsResult {
        val builder = GetPredictionTrainingResultsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPredictionTrainingResultsResultToKotlin(getPredictionTrainingResultsPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified profile.
     * Azure REST API version: 2017-04-26.
     * @param argument null
     * @return The profile resource format.
     */
    public suspend fun getProfile(argument: GetProfilePlainArgs): GetProfileResult =
        getProfileResultToKotlin(getProfilePlain(argument.toJava()).await())

    /**
     * @see [getProfile].
     * @param hubName The name of the hub.
     * @param localeCode Locale of profile to retrieve, default is en-us.
     * @param profileName The name of the profile.
     * @param resourceGroupName The name of the resource group.
     * @return The profile resource format.
     */
    public suspend fun getProfile(
        hubName: String,
        localeCode: String? = null,
        profileName: String,
        resourceGroupName: String,
    ): GetProfileResult {
        val argument = GetProfilePlainArgs(
            hubName = hubName,
            localeCode = localeCode,
            profileName = profileName,
            resourceGroupName = resourceGroupName,
        )
        return getProfileResultToKotlin(getProfilePlain(argument.toJava()).await())
    }

    /**
     * @see [getProfile].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;customerinsights&#46;kotlin&#46;inputs&#46;GetProfilePlainArgs].
     * @return The profile resource format.
     */
    public suspend fun getProfile(argument: suspend GetProfilePlainArgsBuilder.() -> Unit):
        GetProfileResult {
        val builder = GetProfilePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProfileResultToKotlin(getProfilePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified relationship.
     * Azure REST API version: 2017-04-26.
     * @param argument null
     * @return The relationship resource format.
     */
    public suspend fun getRelationship(argument: GetRelationshipPlainArgs): GetRelationshipResult =
        getRelationshipResultToKotlin(getRelationshipPlain(argument.toJava()).await())

    /**
     * @see [getRelationship].
     * @param hubName The name of the hub.
     * @param relationshipName The name of the relationship.
     * @param resourceGroupName The name of the resource group.
     * @return The relationship resource format.
     */
    public suspend fun getRelationship(
        hubName: String,
        relationshipName: String,
        resourceGroupName: String,
    ): GetRelationshipResult {
        val argument = GetRelationshipPlainArgs(
            hubName = hubName,
            relationshipName = relationshipName,
            resourceGroupName = resourceGroupName,
        )
        return getRelationshipResultToKotlin(getRelationshipPlain(argument.toJava()).await())
    }

    /**
     * @see [getRelationship].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;customerinsights&#46;kotlin&#46;inputs&#46;GetRelationshipPlainArgs].
     * @return The relationship resource format.
     */
    public suspend fun getRelationship(argument: suspend GetRelationshipPlainArgsBuilder.() -> Unit):
        GetRelationshipResult {
        val builder = GetRelationshipPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRelationshipResultToKotlin(getRelationshipPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about the specified relationship Link.
     * Azure REST API version: 2017-04-26.
     * Other available API versions: 2017-01-01.
     * @param argument null
     * @return The relationship link resource format.
     */
    public suspend fun getRelationshipLink(argument: GetRelationshipLinkPlainArgs):
        GetRelationshipLinkResult =
        getRelationshipLinkResultToKotlin(getRelationshipLinkPlain(argument.toJava()).await())

    /**
     * @see [getRelationshipLink].
     * @param hubName The name of the hub.
     * @param relationshipLinkName The name of the relationship link.
     * @param resourceGroupName The name of the resource group.
     * @return The relationship link resource format.
     */
    public suspend fun getRelationshipLink(
        hubName: String,
        relationshipLinkName: String,
        resourceGroupName: String,
    ): GetRelationshipLinkResult {
        val argument = GetRelationshipLinkPlainArgs(
            hubName = hubName,
            relationshipLinkName = relationshipLinkName,
            resourceGroupName = resourceGroupName,
        )
        return getRelationshipLinkResultToKotlin(getRelationshipLinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getRelationshipLink].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;customerinsights&#46;kotlin&#46;inputs&#46;GetRelationshipLinkPlainArgs].
     * @return The relationship link resource format.
     */
    public suspend
    fun getRelationshipLink(argument: suspend GetRelationshipLinkPlainArgsBuilder.() -> Unit):
        GetRelationshipLinkResult {
        val builder = GetRelationshipLinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRelationshipLinkResultToKotlin(getRelationshipLinkPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the role assignment in the hub.
     * Azure REST API version: 2017-04-26.
     * @param argument null
     * @return The Role Assignment resource format.
     */
    public suspend fun getRoleAssignment(argument: GetRoleAssignmentPlainArgs):
        GetRoleAssignmentResult =
        getRoleAssignmentResultToKotlin(getRoleAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getRoleAssignment].
     * @param assignmentName The name of the role assignment.
     * @param hubName The name of the hub.
     * @param resourceGroupName The name of the resource group.
     * @return The Role Assignment resource format.
     */
    public suspend fun getRoleAssignment(
        assignmentName: String,
        hubName: String,
        resourceGroupName: String,
    ): GetRoleAssignmentResult {
        val argument = GetRoleAssignmentPlainArgs(
            assignmentName = assignmentName,
            hubName = hubName,
            resourceGroupName = resourceGroupName,
        )
        return getRoleAssignmentResultToKotlin(getRoleAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getRoleAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;customerinsights&#46;kotlin&#46;inputs&#46;GetRoleAssignmentPlainArgs].
     * @return The Role Assignment resource format.
     */
    public suspend
    fun getRoleAssignment(argument: suspend GetRoleAssignmentPlainArgsBuilder.() -> Unit):
        GetRoleAssignmentResult {
        val builder = GetRoleAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRoleAssignmentResultToKotlin(getRoleAssignmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a view in the hub.
     * Azure REST API version: 2017-04-26.
     * @param argument null
     * @return The view resource format.
     */
    public suspend fun getView(argument: GetViewPlainArgs): GetViewResult =
        getViewResultToKotlin(getViewPlain(argument.toJava()).await())

    /**
     * @see [getView].
     * @param hubName The name of the hub.
     * @param resourceGroupName The name of the resource group.
     * @param userId The user ID. Use * to retrieve hub level view.
     * @param viewName The name of the view.
     * @return The view resource format.
     */
    public suspend fun getView(
        hubName: String,
        resourceGroupName: String,
        userId: String,
        viewName: String,
    ): GetViewResult {
        val argument = GetViewPlainArgs(
            hubName = hubName,
            resourceGroupName = resourceGroupName,
            userId = userId,
            viewName = viewName,
        )
        return getViewResultToKotlin(getViewPlain(argument.toJava()).await())
    }

    /**
     * @see [getView].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;customerinsights&#46;kotlin&#46;inputs&#46;GetViewPlainArgs].
     * @return The view resource format.
     */
    public suspend fun getView(argument: suspend GetViewPlainArgsBuilder.() -> Unit): GetViewResult {
        val builder = GetViewPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getViewResultToKotlin(getViewPlain(builtArgument.toJava()).await())
    }
}
