@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin

import com.pulumi.azurenative.customerinsights.kotlin.outputs.PropertyDefinitionResponse
import com.pulumi.azurenative.customerinsights.kotlin.outputs.RelationshipTypeMappingResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.customerinsights.kotlin.outputs.PropertyDefinitionResponse.Companion.toKotlin as propertyDefinitionResponseToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.RelationshipTypeMappingResponse.Companion.toKotlin as relationshipTypeMappingResponseToKotlin

/**
 * Builder for [Relationship].
 */
@PulumiTagMarker
public class RelationshipResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RelationshipArgs = RelationshipArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RelationshipArgsBuilder.() -> Unit) {
        val builder = RelationshipArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Relationship {
        val builtJavaResource =
            com.pulumi.azurenative.customerinsights.Relationship(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Relationship(builtJavaResource)
    }
}

/**
 * The relationship resource format.
 * Azure REST API version: 2017-04-26. Prior API version in Azure Native 1.x: 2017-04-26.
 * ## Example Usage
 * ### Relationships_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var relationship = new AzureNative.CustomerInsights.Relationship("relationship", new()
 *     {
 *         Cardinality = AzureNative.CustomerInsights.CardinalityTypes.OneToOne,
 *         Description =
 *         {
 *             { "en-us", "Relationship Description" },
 *         },
 *         DisplayName =
 *         {
 *             { "en-us", "Relationship DisplayName" },
 *         },
 *         Fields = new[] {},
 *         HubName = "sdkTestHub",
 *         ProfileType = "testProfile2326994",
 *         RelatedProfileType = "testProfile2326994",
 *         RelationshipName = "SomeRelationship",
 *         ResourceGroupName = "TestHubRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customerinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customerinsights.NewRelationship(ctx, "relationship", &customerinsights.RelationshipArgs{
 * 			Cardinality: customerinsights.CardinalityTypesOneToOne,
 * 			Description: pulumi.StringMap{
 * 				"en-us": pulumi.String("Relationship Description"),
 * 			},
 * 			DisplayName: pulumi.StringMap{
 * 				"en-us": pulumi.String("Relationship DisplayName"),
 * 			},
 * 			Fields:             customerinsights.PropertyDefinitionArray{},
 * 			HubName:            pulumi.String("sdkTestHub"),
 * 			ProfileType:        pulumi.String("testProfile2326994"),
 * 			RelatedProfileType: pulumi.String("testProfile2326994"),
 * 			RelationshipName:   pulumi.String("SomeRelationship"),
 * 			ResourceGroupName:  pulumi.String("TestHubRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customerinsights.Relationship;
 * import com.pulumi.azurenative.customerinsights.RelationshipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var relationship = new Relationship("relationship", RelationshipArgs.builder()
 *             .cardinality("OneToOne")
 *             .description(Map.of("en-us", "Relationship Description"))
 *             .displayName(Map.of("en-us", "Relationship DisplayName"))
 *             .fields()
 *             .hubName("sdkTestHub")
 *             .profileType("testProfile2326994")
 *             .relatedProfileType("testProfile2326994")
 *             .relationshipName("SomeRelationship")
 *             .resourceGroupName("TestHubRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customerinsights:Relationship sdkTestHub/testProfile2326994 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationships/{relationshipName}
 * ```
 */
public class Relationship internal constructor(
    override val javaResource: com.pulumi.azurenative.customerinsights.Relationship,
) : KotlinCustomResource(javaResource, RelationshipMapper) {
    /**
     * The Relationship Cardinality.
     */
    public val cardinality: Output<String>?
        get() = javaResource.cardinality().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Localized descriptions for the Relationship.
     */
    public val description: Output<Map<String, String>>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Localized display name for the Relationship.
     */
    public val displayName: Output<Map<String, String>>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The expiry date time in UTC.
     */
    public val expiryDateTimeUtc: Output<String>?
        get() = javaResource.expiryDateTimeUtc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The properties of the Relationship.
     */
    public val fields: Output<List<PropertyDefinitionResponse>>?
        get() = javaResource.fields().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> propertyDefinitionResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Optional property to be used to map fields in profile to their strong ids in related profile.
     */
    public val lookupMappings: Output<List<RelationshipTypeMappingResponse>>?
        get() = javaResource.lookupMappings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        relationshipTypeMappingResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Profile type.
     */
    public val profileType: Output<String>
        get() = javaResource.profileType().applyValue({ args0 -> args0 })

    /**
     * Provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Related profile being referenced.
     */
    public val relatedProfileType: Output<String>
        get() = javaResource.relatedProfileType().applyValue({ args0 -> args0 })

    /**
     * The relationship guid id.
     */
    public val relationshipGuidId: Output<String>
        get() = javaResource.relationshipGuidId().applyValue({ args0 -> args0 })

    /**
     * The Relationship name.
     */
    public val relationshipName: Output<String>
        get() = javaResource.relationshipName().applyValue({ args0 -> args0 })

    /**
     * The hub name.
     */
    public val tenantId: Output<String>
        get() = javaResource.tenantId().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RelationshipMapper : ResourceMapper<Relationship> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.customerinsights.Relationship::class == javaResource::class

    override fun map(javaResource: Resource): Relationship = Relationship(
        javaResource as
            com.pulumi.azurenative.customerinsights.Relationship,
    )
}

/**
 * @see [Relationship].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Relationship].
 */
public suspend fun relationship(
    name: String,
    block: suspend RelationshipResourceBuilder.() -> Unit,
): Relationship {
    val builder = RelationshipResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Relationship].
 * @param name The _unique_ name of the resulting resource.
 */
public fun relationship(name: String): Relationship {
    val builder = RelationshipResourceBuilder()
    builder.name(name)
    return builder.build()
}
