@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin

import com.pulumi.azurenative.customerinsights.kotlin.outputs.ParticipantProfilePropertyReferenceResponse
import com.pulumi.azurenative.customerinsights.kotlin.outputs.RelationshipLinkFieldMappingResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.customerinsights.kotlin.outputs.ParticipantProfilePropertyReferenceResponse.Companion.toKotlin as participantProfilePropertyReferenceResponseToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.RelationshipLinkFieldMappingResponse.Companion.toKotlin as relationshipLinkFieldMappingResponseToKotlin

/**
 * Builder for [RelationshipLink].
 */
@PulumiTagMarker
public class RelationshipLinkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RelationshipLinkArgs = RelationshipLinkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RelationshipLinkArgsBuilder.() -> Unit) {
        val builder = RelationshipLinkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RelationshipLink {
        val builtJavaResource =
            com.pulumi.azurenative.customerinsights.RelationshipLink(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RelationshipLink(builtJavaResource)
    }
}

/**
 * The relationship link resource format.
 * Azure REST API version: 2017-04-26. Prior API version in Azure Native 1.x: 2017-04-26.
 * Other available API versions: 2017-01-01.
 * ## Example Usage
 * ### RelationshipLinks_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var relationshipLink = new AzureNative.CustomerInsights.RelationshipLink("relationshipLink", new()
 *     {
 *         Description =
 *         {
 *             { "en-us", "Link Description" },
 *         },
 *         DisplayName =
 *         {
 *             { "en-us", "Link DisplayName" },
 *         },
 *         HubName = "sdkTestHub",
 *         InteractionType = "testInteraction4332",
 *         ProfilePropertyReferences = new[]
 *         {
 *             new AzureNative.CustomerInsights.Inputs.ParticipantProfilePropertyReferenceArgs
 *             {
 *                 InteractionPropertyName = "profile1",
 *                 ProfilePropertyName = "ProfileId",
 *             },
 *         },
 *         RelatedProfilePropertyReferences = new[]
 *         {
 *             new AzureNative.CustomerInsights.Inputs.ParticipantProfilePropertyReferenceArgs
 *             {
 *                 InteractionPropertyName = "profile1",
 *                 ProfilePropertyName = "ProfileId",
 *             },
 *         },
 *         RelationshipLinkName = "Somelink",
 *         RelationshipName = "testProfile2326994",
 *         ResourceGroupName = "TestHubRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customerinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customerinsights.NewRelationshipLink(ctx, "relationshipLink", &customerinsights.RelationshipLinkArgs{
 * 			Description: pulumi.StringMap{
 * 				"en-us": pulumi.String("Link Description"),
 * 			},
 * 			DisplayName: pulumi.StringMap{
 * 				"en-us": pulumi.String("Link DisplayName"),
 * 			},
 * 			HubName:         pulumi.String("sdkTestHub"),
 * 			InteractionType: pulumi.String("testInteraction4332"),
 * 			ProfilePropertyReferences: []customerinsights.ParticipantProfilePropertyReferenceArgs{
 * 				{
 * 					InteractionPropertyName: pulumi.String("profile1"),
 * 					ProfilePropertyName:     pulumi.String("ProfileId"),
 * 				},
 * 			},
 * 			RelatedProfilePropertyReferences: []customerinsights.ParticipantProfilePropertyReferenceArgs{
 * 				{
 * 					InteractionPropertyName: pulumi.String("profile1"),
 * 					ProfilePropertyName:     pulumi.String("ProfileId"),
 * 				},
 * 			},
 * 			RelationshipLinkName: pulumi.String("Somelink"),
 * 			RelationshipName:     pulumi.String("testProfile2326994"),
 * 			ResourceGroupName:    pulumi.String("TestHubRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customerinsights.RelationshipLink;
 * import com.pulumi.azurenative.customerinsights.RelationshipLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var relationshipLink = new RelationshipLink("relationshipLink", RelationshipLinkArgs.builder()
 *             .description(Map.of("en-us", "Link Description"))
 *             .displayName(Map.of("en-us", "Link DisplayName"))
 *             .hubName("sdkTestHub")
 *             .interactionType("testInteraction4332")
 *             .profilePropertyReferences(Map.ofEntries(
 *                 Map.entry("interactionPropertyName", "profile1"),
 *                 Map.entry("profilePropertyName", "ProfileId")
 *             ))
 *             .relatedProfilePropertyReferences(Map.ofEntries(
 *                 Map.entry("interactionPropertyName", "profile1"),
 *                 Map.entry("profilePropertyName", "ProfileId")
 *             ))
 *             .relationshipLinkName("Somelink")
 *             .relationshipName("testProfile2326994")
 *             .resourceGroupName("TestHubRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customerinsights:RelationshipLink sdkTestHub/Somelink /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/relationshipLinks/{relationshipLinkName}
 * ```
 */
public class RelationshipLink internal constructor(
    override val javaResource: com.pulumi.azurenative.customerinsights.RelationshipLink,
) : KotlinCustomResource(javaResource, RelationshipLinkMapper) {
    /**
     * Localized descriptions for the Relationship Link.
     */
    public val description: Output<Map<String, String>>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Localized display name for the Relationship Link.
     */
    public val displayName: Output<Map<String, String>>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The InteractionType associated with the Relationship Link.
     */
    public val interactionType: Output<String>
        get() = javaResource.interactionType().applyValue({ args0 -> args0 })

    /**
     * The name of the Relationship Link.
     */
    public val linkName: Output<String>
        get() = javaResource.linkName().applyValue({ args0 -> args0 })

    /**
     * The mappings between Interaction and Relationship fields.
     */
    public val mappings: Output<List<RelationshipLinkFieldMappingResponse>>?
        get() = javaResource.mappings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> relationshipLinkFieldMappingResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The property references for the Profile of the Relationship.
     */
    public val profilePropertyReferences: Output<List<ParticipantProfilePropertyReferenceResponse>>
        get() = javaResource.profilePropertyReferences().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> participantProfilePropertyReferenceResponseToKotlin(args0) })
            })
        })

    /**
     * Provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The property references for the Related Profile of the Relationship.
     */
    public val relatedProfilePropertyReferences:
        Output<List<ParticipantProfilePropertyReferenceResponse>>
        get() = javaResource.relatedProfilePropertyReferences().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> participantProfilePropertyReferenceResponseToKotlin(args0) })
            })
        })

    /**
     * The relationship guid id.
     */
    public val relationshipGuidId: Output<String>
        get() = javaResource.relationshipGuidId().applyValue({ args0 -> args0 })

    /**
     * The Relationship associated with the Link.
     */
    public val relationshipName: Output<String>
        get() = javaResource.relationshipName().applyValue({ args0 -> args0 })

    /**
     * The hub name.
     */
    public val tenantId: Output<String>
        get() = javaResource.tenantId().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RelationshipLinkMapper : ResourceMapper<RelationshipLink> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.customerinsights.RelationshipLink::class == javaResource::class

    override fun map(javaResource: Resource): RelationshipLink = RelationshipLink(
        javaResource as
            com.pulumi.azurenative.customerinsights.RelationshipLink,
    )
}

/**
 * @see [RelationshipLink].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RelationshipLink].
 */
public suspend fun relationshipLink(
    name: String,
    block: suspend RelationshipLinkResourceBuilder.() -> Unit,
): RelationshipLink {
    val builder = RelationshipLinkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RelationshipLink].
 * @param name The _unique_ name of the resulting resource.
 */
public fun relationshipLink(name: String): RelationshipLink {
    val builder = RelationshipLinkResourceBuilder()
    builder.name(name)
    return builder.build()
}
